#!/system/bin/sh

path="/sys/devices/system/cpu"
interactive_path="$path/cpufreq/interactive"
scaling_max_freq="cpufreq/scaling_max_freq"
scaling_min_freq="cpufreq/scaling_min_freq"
cpuinfo_max_freq="cpufreq/cpuinfo_max_freq"
cpu0="$path/cpu0"
LOG_TAG="CPU_Freq_Normal"

logi()
{
     /system/bin/log -t $LOG_TAG -p i $1
}

check()
{
	if [ $1 == 0 ]; then
		logi "set $2 success!"
	else
		logi "set $2 fail!"
	fi
}

write()
{
	echo $1 > $2
}

MAX_FREQ=`cat $cpu0/$cpuinfo_max_freq`
MAX_FREQ=`echo $MAX_FREQ`
MIN_FREQ=500000

logi "CPU in Balance mode"

if [[ $MAX_FREQ == "1333000" ]]; then
	logi "CPU freq is 1.333GHz"
	HISPEED_FREQ=1333000
elif [[ $MAX_FREQ == "1833000" ]]; then
	logi "CPU freq is 1.833GHz"
	HISPEED_FREQ=1416000
elif [[ $MAX_FREQ == "2333000" ]]; then
	logi "CPU freq is 2.333GHz"
	HISPEED_FREQ=1833000
else
	logi "Error: other CPU freq...."
	exit 1
fi

HISPEED_LOAD=80
MIN_SAMPLE_TIME=50000
TOUCHBOOST_FREQ=1333000
ROTATIONBOOST_FREQ=$MAX_FREQ

write $MAX_FREQ $cpu0/$scaling_max_freq
check $? "cpu0 scaling_max_freq"
write $MIN_FREQ $cpu0/$scaling_min_freq
check $? "cpu0 scaling_min_freq"

for INDEX in 1 2 3
do
	ONLINE=`cat $path/cpu${INDEX}/online`
	if [[ "$ONLINE" == "1"* ]];
	then
	write $MAX_FREQ $path/cpu${INDEX}/$scaling_max_freq
	check $? "cpu${INDEX} scaling_max_freq"
	write $MIN_FREQ $path/cpu${INDEX}/$scaling_min_freq
	check $? "cpu${INDEX} scaling_min_freq"
	fi
done

write $HISPEED_LOAD $interactive_path/go_hispeed_load
check $? "go_hispeed_load"
write $MIN_SAMPLE_TIME $interactive_path/min_sample_time
check $? "min_sample_time"
write $HISPEED_FREQ $interactive_path/hispeed_freq
check $? "hispeed_freq"
write $TOUCHBOOST_FREQ $interactive_path/touchboost_freq
check $? "touchboost_freq"
write $ROTATIONBOOST_FREQ $interactive_path/rotationboost_freq
check $? "rotationboost_freq"
