/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.recommendation;

import com.intel.api.Intel;
import com.intel.b.a;
import com.intel.core.RowIterator;
import com.intel.core.recommendation.Feedback;
import com.intel.core.recommendation.Recommendation;
import com.intel.core.recommendation.RecommendationItem;
import com.intel.core.recommendation.RecommendationOption;
import com.intel.exception.InvalidRangeParameter;
import com.intel.exception.RecommendationException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecommendationIterator
implements a,
RowIterator {
    private int a;
    private Integer b;
    private Integer c;
    private Integer d;
    private Integer e;
    private String f;
    private String g;
    private String h;
    private RecommendationOption i;
    private JSONArray j;
    public static final int USER_SIMILAR_ITEMS = 0;
    public static final int USER_RECOMENDATION = 1;
    public static final int SIMILAR_ITEMS = 2;
    public static final int ACTION_TYPE = 3;
    public static final int RATE_HISTORY = 4;
    public static final int PURCHASE_HISTORY = 5;
    public static final int REVIEWS = 6;
    public static final int REVIEW_HISTORY = 7;

    public Integer getTotalItems() {
        return this.b;
    }

    public Integer getLimit() {
        return this.c;
    }

    public Integer getStartIndex() {
        return this.d;
    }

    public Integer getPageNumber() {
        return this.e;
    }

    public String getPrevious() {
        return this.f;
    }

    public String getNext() {
        return this.g;
    }

    public String getType() {
        return this.h;
    }

    public RecommendationOption getOption() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    public void setOption(RecommendationOption optionPage) {
        void var1_1;
        this.i = var1_1;
    }

    public int getProvider() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setProvider(int provider) {
        void var1_1;
        this.a = var1_1;
    }

    @Override
    public void next() throws InvalidRangeParameter {
        if (!this.hasNext()) {
            throw new InvalidRangeParameter("Invalid range parameter.");
        }
        try {
            RecommendationIterator recommendationIterator = this.getIteratorProvider(null, this.g);
            this.a(recommendationIterator);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new InvalidRangeParameter("Error in next()", exception2);
        }
    }

    @Override
    public void previous() throws InvalidRangeParameter {
        if (!this.hasPrevious()) {
            throw new InvalidRangeParameter("Invalid range parameter.");
        }
        try {
            RecommendationIterator recommendationIterator = this.getIteratorProvider(null, this.f);
            this.a(recommendationIterator);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new InvalidRangeParameter("Error in previous()", exception2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void position(int page) throws InvalidRangeParameter {
        Object object = this.getOption();
        if (!this.hasPage(page) || object == null) {
            throw new InvalidRangeParameter("Invalid range parameter.");
        }
        try {
            void var1_1;
            ((RecommendationOption)object).setOffset(page * this.c - this.c);
            object = this.getIteratorProvider((RecommendationOption)object, null);
            this.a((RecommendationIterator)object);
            --page;
            this.e = (int)var1_1;
            return;
        }
        catch (Exception exception) {
            throw new InvalidRangeParameter("Error in previous()", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void jsonToObject(JSONObject aJsonObject) throws JSONException {
        Object object;
        if (aJsonObject.has("Meta")) {
            object = aJsonObject.getJSONObject("Meta");
            this.h = object.getString("Type");
            if (object.has("Paging")) {
                object = object.getJSONObject("Paging");
                this.b = object.getInt("TotalItems");
                this.c = object.getInt("Limit");
                this.d = object.getInt("StartIndex");
                this.e = object.getInt("PageNumber");
                String string = object.getString("Previous");
                this.f = string.equals("null") ? null : string;
                object = object.getString("Next");
                Object object2 = this.g = ((String)object).equals("null") ? null : object;
            }
        }
        if (aJsonObject.has("Data")) {
            void var1_1;
            object = var1_1.getJSONObject("Data");
            if (object.has("Recommendation")) {
                this.j = object.getJSONArray("Recommendation");
                return;
            }
            if (object.has("purchase")) {
                this.j = object.getJSONArray("purchase");
                return;
            }
            if (object.has("rate")) {
                this.j = object.getJSONArray("rate");
                return;
            }
            if (object.has("review")) {
                this.j = object.getJSONArray("review");
                return;
            }
            if (object.has("actionType")) {
                this.j = object.getJSONArray("actionType");
            }
        }
    }

    public List<RecommendationItem> getItems() throws JSONException {
        ArrayList<RecommendationItem> arrayList = new ArrayList<RecommendationItem>();
        if (this.j != null) {
            for (int k = 0; k < this.j.length(); ++k) {
                arrayList.add(new RecommendationItem(this.j.getJSONObject(k)));
            }
        }
        return arrayList;
    }

    public JSONObject objectToJson() throws JSONException {
        return null;
    }

    public boolean hasNext() {
        return this.g != null;
    }

    public boolean hasPrevious() {
        return this.f != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasPage(int page) {
        if (page > 0) {
            void var1_1;
            return var1_1 * this.c - this.c < this.b;
        }
        return false;
    }

    private void a(RecommendationIterator recommendationIterator) {
        this.b = recommendationIterator.getTotalItems();
        this.e = recommendationIterator.getPageNumber();
        this.d = recommendationIterator.getStartIndex();
        this.c = recommendationIterator.getLimit();
        this.g = recommendationIterator.getNext();
        this.f = recommendationIterator.getPrevious();
        this.j = recommendationIterator.j;
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getIteratorProvider(RecommendationOption option, String link) throws RecommendationException {
        RecommendationIterator recommendationIterator = null;
        Feedback feedback = new Feedback();
        switch (this.a) {
            case 0: {
                recommendationIterator = ((Recommendation)Intel.recommendation).getUserSimilarItems(option, link);
                break;
            }
            case 1: {
                recommendationIterator = ((Recommendation)Intel.recommendation).getUserRecommendation(option, link);
                break;
            }
            case 2: {
                recommendationIterator = ((Recommendation)Intel.recommendation).getSimilarItems(option, link);
                break;
            }
            case 3: {
                recommendationIterator = feedback.getActionType(option, link);
                break;
            }
            case 5: {
                recommendationIterator = feedback.getPurchaseHistory(option, link);
                break;
            }
            case 4: {
                recommendationIterator = feedback.getRateHistory(option, link);
                break;
            }
            case 7: {
                recommendationIterator = feedback.getReviewHistory(option, link);
                break;
            }
            case 6: {
                void var2_2;
                void var1_1;
                recommendationIterator = feedback.getReviews((RecommendationOption)var1_1, (String)var2_2);
            }
        }
        return recommendationIterator;
    }
}

