/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.recommendation;

import com.intel.a.a.c;
import com.intel.a.a.d;
import com.intel.api.Intel;
import com.intel.api.RecommendationAPI;
import com.intel.b.b;
import com.intel.common.Settings;
import com.intel.core.AccessToken;
import com.intel.core.auth.Auth;
import com.intel.core.catalog.CatalogItem;
import com.intel.core.filter.FilterQuery;
import com.intel.core.recommendation.RecommendationIterator;
import com.intel.core.recommendation.RecommendationOption;
import com.intel.exception.NotAuthenticatedException;
import com.intel.exception.RecommendationException;
import com.intel.exception.RestException;
import org.json.JSONException;
import org.json.JSONObject;

public class Recommendation
implements RecommendationAPI {
    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getSimilarItems(CatalogItem item, RelationshipType relationshipType) throws RecommendationException {
        void var2_2;
        void var1_1;
        RecommendationOption recommendationOption = new RecommendationOption();
        recommendationOption.setItem((CatalogItem)var1_1);
        recommendationOption.setType((RelationshipType)var2_2);
        if (recommendationOption.getItem() == null || recommendationOption.getItem().getItemId() == null || recommendationOption.getItem().getItemId().length() == 0 || recommendationOption.getItem().getLink() == null || recommendationOption.getItem().getLink().length() == 0) {
            throw new RecommendationException("item should be an object with at least id and link properties.");
        }
        return this.getSimilarItems(recommendationOption, null);
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getSimilarItems(RecommendationOption option, String link) throws RecommendationException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.APP_AUTHORIZATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            try {
                object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
            }
            catch (NotAuthenticatedException notAuthenticatedException2) {
                throw new RecommendationException("Authentication required to perform this action", notAuthenticatedException);
            }
        }
        try {
            void var1_1;
            c c2;
            if (link != null) {
                void var2_2;
                c2 = new c((String)var2_2);
            } else {
                c2 = new c(Settings.getRecommendationItems(), option.getItem().getItemId(), option.getType().toString());
                if (option.getOffset() != null) {
                    c2.b("$offset", option.getOffset().toString());
                }
            }
            c2.a("authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(1, RecommendationIterator.class);
            ((RecommendationIterator)object).setOption((RecommendationOption)var1_1);
            ((RecommendationIterator)object).setProvider(2);
        }
        catch (RestException restException) {
            throw new RecommendationException(restException.getMessage());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new RecommendationException("Error to perform this action", exception2);
        }
        return object;
    }

    public Double getUserEstimation(CatalogItem item) throws RecommendationException {
        String string;
        Double d2 = null;
        if (item == null || item.getItemId() == null || item.getItemId().length() == 0 || item.getLink() == null || item.getLink().length() == 0) {
            throw new RecommendationException("item should be an object with at least id and link properties.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new RecommendationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            object = new c(Settings.getRecommendationUser(), "preference", ((CatalogItem)object).getItemId());
            ((c)object).a("authorization", string);
            ((c)object).a("Content-Type", "application/json");
            object = ((c)object).a(1);
            if (((d)object).b() == 200) {
                d2 = ((d)object).a().getDouble("data");
            } else {
                b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new RecommendationException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new RecommendationException("Error to perform this action", exception);
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getUserRecommendation(FilterQuery query, String fields, String orderby, Integer limit, Integer offset, String dayOfWeek, JSONObject location, String place, String timeOfDay) throws RecommendationException {
        void var3_3;
        void var2_2;
        void var1_1;
        RecommendationOption recommendationOption = new RecommendationOption();
        recommendationOption.setFilter((FilterQuery)var1_1);
        recommendationOption.setFields((String)var2_2);
        recommendationOption.setOrderby((String)var3_3);
        recommendationOption.setLimit(limit);
        recommendationOption.setOffset(offset);
        recommendationOption.setDayOfWeek(dayOfWeek);
        recommendationOption.setLocation(location);
        recommendationOption.setPlace(place);
        recommendationOption.setTimeOfDay(timeOfDay);
        return this.getUserRecommendation(recommendationOption);
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getUserRecommendation(RecommendationOption option) throws RecommendationException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new RecommendationException("Authentication required to perform this action", notAuthenticatedException);
        }
        c c2 = new c(Settings.getRecommendationUser());
        Recommendation.a(option, c2);
        Object object2 = this.checkContext(option.getDayOfWeek(), option.getLocation(), option.getPlace(), option.getTimeOfDay());
        if (object2.length() == 4 || object2.length() == 0) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("Context", object2);
            }
            catch (JSONException jSONException) {
                object2 = jSONException;
                jSONException.printStackTrace();
            }
            c2.a(jSONObject.toString());
        } else if (object2.length() > 0) {
            throw new RecommendationException("None or All the required fields 'timeOfDay', 'dayOfWeek', 'location' and 'place'.");
        }
        try {
            void var1_1;
            c2.a("authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(2, RecommendationIterator.class);
            ((RecommendationIterator)object).setOption((RecommendationOption)var1_1);
            ((RecommendationIterator)object).setProvider(1);
        }
        catch (RestException restException) {
            throw new RecommendationException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new RecommendationException("Error to perform this action", exception);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getUserRecommendation(RecommendationOption option, String link) throws RecommendationException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new RecommendationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            c c2;
            c2 = new c((String)((Object)c2));
            c2.a("authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(1, RecommendationIterator.class);
            ((RecommendationIterator)object).setOption((RecommendationOption)var1_1);
            ((RecommendationIterator)object).setProvider(1);
        }
        catch (RestException restException) {
            throw new RecommendationException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new RecommendationException("Error to perform this action", exception);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject checkContext(String dayOfWeek, JSONObject location, String place, String timeOfDay) {
        JSONException jSONException;
        JSONObject jSONObject = new JSONObject();
        try {
            if (dayOfWeek != null && dayOfWeek.length() > 0) {
                jSONObject.put("day-of-week", (Object)jSONException);
            }
            if (location != null && location.length() > 0) {
                void var2_2;
                jSONObject.put("location", (Object)var2_2);
            }
            if (place != null && place.length() > 0) {
                void var3_3;
                jSONObject.put("place", (Object)var3_3);
            }
            if (timeOfDay != null && timeOfDay.length() > 0) {
                jSONObject.put("time-of-day", (Object)timeOfDay);
            }
        }
        catch (JSONException jSONException2) {
            jSONException = jSONException2;
            jSONException2.printStackTrace();
        }
        return jSONObject;
    }

    private static void a(RecommendationOption recommendationOption, c c2) {
        if (recommendationOption.getFilter() != null) {
            c2.b("$filter", recommendationOption.getFilter().toODataString());
        }
        if (recommendationOption.getFields() != null) {
            c2.b("$fields", recommendationOption.getFields());
        }
        if (recommendationOption.getOrderby() != null) {
            c2.b("$orderby", recommendationOption.getOrderby());
        }
        if (recommendationOption.getOffset() != null) {
            c2.b("$offset", String.valueOf(recommendationOption.getOffset()));
        }
        if (recommendationOption.getLimit() != null) {
            c2.b("$limit", String.valueOf(recommendationOption.getLimit()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getUserSimilarItems(CatalogItem item, FilterQuery query, String fields, String orderby, Integer limit, Integer offset) throws RecommendationException {
        void var3_3;
        void var1_1;
        void var2_2;
        RecommendationOption recommendationOption = new RecommendationOption();
        recommendationOption.setFilter((FilterQuery)var2_2);
        recommendationOption.setItem((CatalogItem)var1_1);
        recommendationOption.setFields((String)var3_3);
        recommendationOption.setOrderby(orderby);
        recommendationOption.setLimit(limit);
        recommendationOption.setOffset(offset);
        return this.getUserSimilarItems(recommendationOption, null);
    }

    /*
     * WARNING - void declaration
     */
    public RecommendationIterator getUserSimilarItems(RecommendationOption option, String link) throws RecommendationException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new RecommendationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            c c2;
            if (c2 != null) {
                c2 = new c((String)((Object)c2));
            } else {
                c2 = new c(Settings.getRecommendationUser(), "related", option.getItem().getItemId());
                Recommendation.a(option, c2);
            }
            c2.a("authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(1, RecommendationIterator.class);
            ((RecommendationIterator)object).setOption((RecommendationOption)var1_1);
            ((RecommendationIterator)object).setProvider(0);
        }
        catch (RestException restException) {
            throw new RecommendationException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new RecommendationException("Error to perform this action", exception);
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelationshipType {
        SIMILARS("similars"),
        CROSS_SELL("cross-sell"),
        UP_SALE("up_sale");

        private final String a;

        /*
         * WARNING - void declaration
         */
        private RelationshipType(String text) {
            void var3_3;
            this.a = var3_3;
        }

        public final String toString() {
            return this.a;
        }
    }
}

