/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.curation;

import com.intel.a.a.c;
import com.intel.a.a.d;
import com.intel.api.Intel;
import com.intel.b.b;
import com.intel.common.Settings;
import com.intel.core.AccessToken;
import com.intel.core.auth.Auth;
import com.intel.core.catalog.CatalogItem;
import com.intel.core.curation.CurationItem;
import com.intel.core.curation.CurationIterator;
import com.intel.core.curation.CurationOption;
import com.intel.core.filter.FilterQuery;
import com.intel.exception.CurationException;
import com.intel.exception.NotAuthenticatedException;
import com.intel.exception.RestException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurationList {
    private String a;
    private JSONObject b;

    public CurationList() {
    }

    /*
     * WARNING - void declaration
     */
    public CurationList(JSONObject aList) throws JSONException {
        void var1_1;
        this.b = aList;
        this.a = var1_1.getString("ListId");
    }

    public String getListId() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setListId(String listId) {
        void var1_1;
        this.a = var1_1;
    }

    public JSONObject getContent() {
        return this.b;
    }

    public JSONObject uploadItem(CatalogItem item) throws CurationException {
        String string;
        JSONObject jSONObject = null;
        if (item == null || item.getItemId() == null || item.getItemId().length() == 0 || item.getLink() == null || item.getLink().length() == 0) {
            throw new CurationException("item should be an object with at least id and link properties.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            d d2;
            c c2 = new c(Settings.getCurationBaseURL(), "me/lists", this.a, "items");
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("CatalogUri", (Object)((CatalogItem)((Object)d2)).getLink());
            c2.a("Authorization", string);
            c2.a("Content-Type", "application/json");
            c2.a(jSONObject2.toString());
            d2 = c2.a(2);
            if (d2.b() == 200) {
                jSONObject = d2.a();
            } else {
                com.intel.b.b.a(d2);
            }
        }
        catch (RestException restException) {
            throw new CurationException(restException);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
        return jSONObject;
    }

    public void deleteItem(String itemId) throws CurationException {
        String string;
        if (itemId == null || itemId.length() == 0) {
            throw new CurationException("The itemId property is Required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            object = new c(Settings.getCurationBaseURL(), "me/lists", this.a, "items/" + (String)object);
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            object = ((c)object).a(4);
            if (((d)object).b() != 204) {
                com.intel.b.b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CurationException(restException);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
    }

    public List<Integer> getVersions() throws CurationException {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            c c2 = new c(Settings.getCurationBaseURL(), "me/lists", this.a, "versions");
            c2.a("Authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(1);
            if (((d)object).b() == 200) {
                object = ((d)object).a().getJSONArray("Versions");
                for (int k = 0; k < object.length(); ++k) {
                    arrayList.add(object.getInt(k));
                }
            } else {
                com.intel.b.b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CurationException(restException);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
        return arrayList;
    }

    public CurationList getMetadata(Integer version) throws CurationException {
        String string;
        CurationList curationList = null;
        if (version == null) {
            throw new CurationException("The version property is Required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            object = new c(Settings.getCurationBaseURL(), "me/lists", this.a, ((Integer)object).toString());
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            object = ((c)object).a(1);
            if (((d)object).b() == 200) {
                curationList = new CurationList(((d)object).a());
            } else {
                com.intel.b.b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CurationException(restException);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
        return curationList;
    }

    public void addFields(JSONObject fields) throws CurationException {
        String string;
        if (fields == null) {
            throw new CurationException("The fields param can't be null.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("Fields", object);
            object = new c(Settings.getCurationBaseURL(), "me", "lists", this.a);
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            ((c)object).a(jSONObject.toString());
            object = ((c)object).a(3);
            if (((d)object).b() != 204) {
                com.intel.b.b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CurationException(restException);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
    }

    public void reorderItems(List<CurationItem> curationItems) throws CurationException {
        String string;
        if (curationItems == null || curationItems.size() == 0) {
            throw new CurationException("The catalogItems param can't be null or empty.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = (CurationItem)object2.next();
                arrayList.add(((CurationItem)object).getItemId());
            }
            object2 = new JSONObject();
            object2.put("Items", (Object)new JSONArray(arrayList));
            object = new c(Settings.getCurationBaseURL(), "me/lists", this.a, "items");
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            ((c)object).a(object2.toString());
            object2 = ((c)object).a(3);
            if (((d)object2).b() != 204 && ((d)object2).b() != 200) {
                com.intel.b.b.a((d)object2);
            }
            return;
        }
        catch (RestException restException) {
            throw new CurationException(restException);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CurationIterator getItems(FilterQuery filter, String fields, Integer limit, Integer offset) throws CurationException, JSONException {
        void var1_1;
        void var2_2;
        void var3_3;
        CurationOption curationOption = new CurationOption();
        curationOption.setListId(this.a);
        curationOption.setLimit((Integer)var3_3);
        curationOption.setOffset(offset);
        curationOption.setFields((String)var2_2);
        curationOption.setFilter((FilterQuery)var1_1);
        return this.getItems(curationOption, null);
    }

    /*
     * WARNING - void declaration
     */
    public CurationIterator getItems(CurationOption optionPage, String link) throws CurationException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            c c2;
            if (c2 != null) {
                c2 = new c((String)((Object)c2));
            } else {
                c2 = new c(Settings.getCurationBaseURL(), "me/lists", optionPage.getListId(), "items");
                if (optionPage.getFilter() != null) {
                    c2.b("$filter", optionPage.getFilter().toODataString());
                }
                if (optionPage.getFields() != null) {
                    c2.b("$fields", optionPage.getFields());
                }
                if (optionPage.getLimit() != null) {
                    c2.b("$limit", String.valueOf(optionPage.getLimit()));
                }
                if (optionPage.getOffset() != null) {
                    c2.b("$offset", String.valueOf(optionPage.getOffset()));
                }
            }
            c2.a("Authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(1, CurationIterator.class);
            ((CurationIterator)object).setOptionPage((CurationOption)var1_1);
            ((CurationIterator)object).setProvider(1);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
        return object;
    }

    public CurationIterator getItemsByVersion(Integer version) throws CurationException {
        CurationOption curationOption;
        curationOption = new CurationOption((Integer)((Object)curationOption));
        curationOption.setListId(this.a);
        return this.getItemsByVersion(curationOption, null);
    }

    /*
     * WARNING - void declaration
     */
    public CurationIterator getItemsByVersion(CurationOption optionPage, String link) throws CurationException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CurationException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            Object object2;
            if (object2 != null) {
                object2 = new c((String)object2);
            } else {
                object2 = "me/lists/" + optionPage.getListId();
                String string = "items/" + optionPage.getVersion();
                object2 = new c(Settings.getCurationBaseURL(), (String)object2, string);
                if (optionPage.getLimit() != null) {
                    ((c)object2).b("$limit", String.valueOf(optionPage.getLimit()));
                }
                if (optionPage.getOffset() != null) {
                    ((c)object2).b("$offset", String.valueOf(optionPage.getOffset()));
                }
            }
            ((c)object2).a("Authorization", (String)object);
            ((c)object2).a("Content-Type", "application/json");
            object = ((c)object2).a(1, CurationIterator.class);
            ((CurationIterator)object).setOptionPage((CurationOption)var1_1);
            ((CurationIterator)object).setProvider(2);
        }
        catch (Exception exception) {
            throw new CurationException("Error to perform this action", exception);
        }
        return object;
    }
}

