/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.commerce;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.intel.a.a.d;
import com.intel.a.b.a;
import com.intel.api.CommerceAPI;
import com.intel.api.Intel;
import com.intel.b.b;
import com.intel.common.Settings;
import com.intel.core.AccessToken;
import com.intel.core.auth.Auth;
import com.intel.core.c.c;
import com.intel.core.commerce.BillingProfile;
import com.intel.core.commerce.Cart;
import com.intel.core.commerce.CartIterator;
import com.intel.core.commerce.PageInfoContainer;
import com.intel.core.commerce.Subscription;
import com.intel.core.commerce.SubscriptionIterator;
import com.intel.exception.CommerceException;
import com.intel.exception.NotAuthenticatedException;
import com.intel.exception.RangeException;
import com.intel.exception.RestException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commerce
implements CommerceAPI {
    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized Cart getCart(Context context, String cartId) throws CommerceException {
        void var2_2;
        return this.a((String)var2_2, false);
    }

    private synchronized Cart a(String object, boolean bl) throws CommerceException {
        String string;
        Cart cart = null;
        if (object == null) {
            throw new CommerceException("The cart/order id is required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            object = new com.intel.a.a.c(Settings.getCommerceBaseURL(), bl ? "orders" : "carts", (String)object);
            ((com.intel.a.a.c)object).a("Authorization", string);
            ((com.intel.a.a.c)object).a("Content-Type", "application/json");
            object = ((com.intel.a.a.c)object).a(1);
            if (((d)object).b() == 200) {
                cart = new Cart(((d)object).a().getJSONObject("data"));
            } else {
                b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
        return cart;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cart getOrder(Context context, String orderId) throws CommerceException {
        void var2_2;
        return this.a((String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CartIterator getCarts(String startDate, String endDate, String status, Integer limit, Integer offset) throws CommerceException, RangeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getCarts(new PageInfoContainer((String)var1_1, (String)var2_2, (String)var3_3, limit, offset, false), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CartIterator getOrders(String startDate, String endDate, String status, Integer limit, Integer offset) throws CommerceException, RangeException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getCarts(new PageInfoContainer((String)var1_1, (String)var2_2, (String)var3_3, limit, offset, true), null);
    }

    /*
     * WARNING - void declaration
     */
    public CartIterator getCarts(PageInfoContainer optionPage, String nextLink) throws CommerceException, RangeException {
        String string;
        Object object = null;
        object = a.a();
        if (object == null) {
            throw new CommerceException("Error trying to open application storage.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            Object object2;
            if (object2 != null) {
                object2 = new com.intel.a.a.c((String)object2);
            } else {
                object2 = ((a)object).a("user_id");
                object = optionPage.isOrder() ? "orders" : "carts";
                object2 = object2 != null ? new com.intel.a.a.c(Settings.getCommerceBaseURL(), "users", (String)object2, (String)object) : new com.intel.a.a.c(Settings.getCommerceBaseURL(), (String)object);
                if (!optionPage.validateStartAndEndDate()) {
                    throw new RangeException("StartDate and EndDate are required.");
                }
                ((com.intel.a.a.c)object2).b("start_date", optionPage.getRange().getStartDate());
                ((com.intel.a.a.c)object2).b("end_date", optionPage.getRange().getEndDate());
                if (optionPage.getLimit() != null) {
                    ((com.intel.a.a.c)object2).b("$limit", optionPage.getLimit().toString());
                }
                if (optionPage.getOffset() != null) {
                    ((com.intel.a.a.c)object2).b("$offset", optionPage.getOffset().toString());
                }
                if (optionPage.getStatus() != null) {
                    ((com.intel.a.a.c)object2).b("status", optionPage.getStatus());
                }
            }
            ((com.intel.a.a.c)object2).a("Authorization", string);
            ((com.intel.a.a.c)object2).a("Content-Type", "application/json; charset=UTF-8");
            object = ((com.intel.a.a.c)object2).a(1, CartIterator.class);
            ((CartIterator)object).setOptionPage((PageInfoContainer)var1_1);
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public CartIterator getCarts(String nextLinkUrl) throws CommerceException, RangeException {
        void var1_1;
        return this.getCarts(null, (String)var1_1);
    }

    @Override
    public List<BillingProfile> getBillingProfile() throws CommerceException {
        Object object;
        ArrayList<BillingProfile> arrayList = new ArrayList<BillingProfile>();
        Object object2 = a.a();
        if (object2 == null) {
            throw new CommerceException("Error trying to open application storage.");
        }
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            object2 = ((a)object2).a("user_id");
            object2 = new com.intel.a.a.c(Settings.getCommerceBaseURL(), "users", (String)object2);
            ((com.intel.a.a.c)object2).a("Authorization", (String)object);
            ((com.intel.a.a.c)object2).a("Content-Type", "application/json; charset=UTF-8");
            object = ((com.intel.a.a.c)object2).a(1);
            if (((d)object).b() == 200) {
                object = ((d)object).a().getJSONObject("data").getJSONArray("items");
                object2 = null;
                for (int k = 0; k < object.length(); ++k) {
                    object2 = new BillingProfile();
                    JSONObject jSONObject = object.getJSONObject(k);
                    ((BillingProfile)object2).setConfirmationType(jSONObject.getString("confirmationType"));
                    ((BillingProfile)object2).setCountry(jSONObject.getString("billingCountry"));
                    ((BillingProfile)object2).setCurrency(jSONObject.getString("billingCurrency"));
                    ((BillingProfile)object2).setPaymentType(jSONObject.getString("paymentType"));
                    ((BillingProfile)object2).setPaymentTypeId(jSONObject.getInt("paymentTypeId"));
                    ((BillingProfile)object2).setPreferredPayment(jSONObject.getInt("preferredPayment"));
                    arrayList.add((BillingProfile)object2);
                }
            } else {
                b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CommerceException(restException);
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void manageBillingProfile(Context appContext, String cartId) throws CommerceException {
        String string;
        Object object;
        Boolean bl = false;
        String string2 = appContext.getPackageName();
        String string3 = "com.intel.core.ui.BillingActivity";
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = Settings.getBillingBaseURL() + "/PaymentMethods2.aspx";
        String string5 = null;
        try {
            object = a.a();
            string5 = ((a)object).a("client_id");
            stringBuilder.append("?apikey=");
            stringBuilder.append(string5);
            if (cartId != null) {
                string4 = Settings.getBillingBaseURL() + "/billingprofile.aspx";
                stringBuilder.append("&cartid=");
                stringBuilder.append(string);
            }
            stringBuilder.append("&locale=");
            string5 = ((a)object).a("locale") != null ? ((a)object).a("locale") : "en-US";
            stringBuilder.append(string5);
            string4 = string4 + stringBuilder.toString();
            string = "Billing URL: " + string4;
            Log.d((String)"CspAndroid", (String)string);
            string = appContext.getPackageManager().getPackageInfo(string2, 1);
            for (int k = 0; k < ((PackageInfo)string).activities.length; ++k) {
                try {
                    ((PackageInfo)string).activities[k].getClass().getField("name");
                    object = ((PackageInfo)string).activities[k].name;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    object = "(none)";
                }
                if (!((String)object).equals(string3)) continue;
                string = "BillingActivity found on AndroidManifest.xml";
                Log.d((String)"CspAndroid", (String)string);
                bl = true;
                break;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new CommerceException("Error trying to read application package. Check context parameter passed on billing method.");
        }
        if (bl.booleanValue()) {
            try {
                void var1_1;
                object = new Intent();
                object.setClassName(string2, string3);
                object.addFlags(0x10000000);
                object.putExtra("billingUrl", string4);
                object.putExtra("locale", string5);
                var1_1.startActivity((Intent)object);
                return;
            }
            catch (Exception exception) {
                throw new CommerceException("Error to perform this action", exception);
            }
        }
        string = "No BillingActivity declared on AndroidManifest.xml!";
        Log.d((String)"CspAndroid", (String)string);
        throw new CommerceException("BillingActivity not found, did you declared it on AndroidManifest.xml?");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createSubscription(Subscription sub) throws CommerceException {
        Object object;
        if (sub.getBillingPeriod() == null || sub.getBillingPeriod().length() == 0 && sub.getBillingType() == null || sub.getBillingType().length() == 0 && sub.getCurrencyType() == null || sub.getCurrencyType().length() == 0 && sub.getMaxNumberPeriods() == null || sub.getMaxNumberPeriods() == 0 && sub.getItem() == null) {
            throw new CommerceException("Invalid parameter. Fields 'billingPeriod', 'maxNumberPeriods', 'billingType', 'currencyType' and 'item' are required");
        }
        if (sub.getItem().getName() == null || sub.getItem().getName().length() == 0 && sub.getItem().getExternalProductCode() == null || sub.getItem().getExternalProductCode().length() == 0 && sub.getItem().getCommodityCode() == null || sub.getItem().getCommodityCode().length() == 0 && sub.getItem().getListPrice() == 0.0 && sub.getItem().getActualPrice() == 0.0) {
            throw new CommerceException("Invalid parameter. Fields 'Name', 'productCode', 'commodityCode', 'listPrice' and 'actualPrice' are required");
        }
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object2;
            Object object3 = a.a();
            if (((String)(object3 = ((a)object3).a("user_id") != null ? ((a)object3).a("user_id") : "")).length() == 0) {
                object2 = Intel.user.getDetails();
                object3 = ((c)object2).a();
            }
            object2 = new com.intel.a.a.c(Settings.getCommerceBaseURL() + "/users/{userId}/subscriptions");
            ((com.intel.a.a.c)object2).a("Content-Type", "application/json");
            ((com.intel.a.a.c)object2).a("authorization", (String)object);
            ((com.intel.a.a.c)object2).c("userId", (String)object3);
            ((com.intel.a.a.c)object2).a(sub.objectToJson().toString());
            object = ((com.intel.a.a.c)object2).a(2);
            if (((d)object).b() == 201) {
                void var1_1;
                var1_1.jsonToObject(((d)object).a());
                return;
            }
            b.a((d)object);
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SubscriptionIterator getSubscriptions(String startDate, String endDate, String status, Integer limit, Integer offset) throws CommerceException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (startDate == null || startDate.length() == 0 || endDate == null || endDate.length() == 0) {
            throw new CommerceException("Invalid parameter. Fields 'startDate' and 'endDate' are requerid.");
        }
        if (!Commerce.a(startDate) || !Commerce.a(endDate)) {
            throw new CommerceException("Invalid parameter. Field 'startDate' and/or 'endDate'. Must be string with UTC format.");
        }
        return this.getSubscriptions(new PageInfoContainer((String)var1_1, (String)var2_2, (String)var3_3, limit, offset), null);
    }

    public SubscriptionIterator getSubscriptions(PageInfoContainer optionPage, String nextLink) throws CommerceException {
        SubscriptionIterator subscriptionIterator;
        String string;
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            if (object != null) {
                object = new com.intel.a.a.c((String)object);
            } else {
                object = a.a();
                String string2 = ((a)object).a("user_id") != null ? ((a)object).a("user_id") : "";
                if (string2.length() == 0) {
                    object = Intel.user.getDetails();
                    string2 = ((c)object).a();
                }
                object = new com.intel.a.a.c(Settings.getCommerceBaseURL() + "/users/{userId}/subscriptions");
                ((com.intel.a.a.c)object).c("userId", string2);
                ((com.intel.a.a.c)object).b("start_date", optionPage.getRange().getStartDate());
                ((com.intel.a.a.c)object).b("end_date", optionPage.getRange().getEndDate());
                if (optionPage.getLimit() != null) {
                    ((com.intel.a.a.c)object).b("$limit", optionPage.getLimit().toString());
                }
                if (optionPage.getOffset() != null) {
                    ((com.intel.a.a.c)object).b("$offset", optionPage.getOffset().toString());
                }
                if (optionPage.getStatus() != null) {
                    ((com.intel.a.a.c)object).b("status", ((PageInfoContainer)((Object)subscriptionIterator)).getStatus());
                }
            }
            ((com.intel.a.a.c)object).a("Content-Type", "application/json");
            ((com.intel.a.a.c)object).a("authorization", string);
            subscriptionIterator = ((com.intel.a.a.c)object).a(1, SubscriptionIterator.class);
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
        return subscriptionIterator;
    }

    private static boolean a(String string) {
        return string != null && string.length() == 8;
    }

    @Override
    public void cancelSubscription(String subscriptionId) throws CommerceException {
        Object object;
        String string;
        if (subscriptionId == null || subscriptionId.length() == 0) {
            throw new CommerceException("Invalid parameter. Field 'subscriptionId' is required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        object = new com.intel.a.a.c(Settings.getCommerceBaseURL() + "/subscriptions/" + (String)object);
        ((com.intel.a.a.c)object).a("authorization", string);
        try {
            object = ((com.intel.a.a.c)object).a(4);
            if (((d)object).b() != 204) {
                b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
    }

    @Override
    public void activateSubscription(String subscriptionId) throws CommerceException {
        String string;
        if (subscriptionId == null || subscriptionId.length() == 0) {
            throw new CommerceException("Invalid parameter. Field 'subscriptionId' is required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            d d2;
            com.intel.a.a.c c2 = new com.intel.a.a.c(Settings.getCommerceBaseURL() + "/subscriptions/{subscriptionId}/purchase");
            c2.a("Content-Type", "application/json");
            c2.a("authorization", string);
            c2.c("subscriptionId", (String)((Object)d2));
            d2 = c2.a(3);
            if (d2.b() != 201 && d2.b() != 200) {
                b.a(d2);
            }
            return;
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refundSubscription(String subscriptionId, Integer refundQuantity) throws CommerceException {
        String string;
        if (subscriptionId == null || subscriptionId.length() == 0 && refundQuantity == null) {
            throw new CommerceException("Invalid parameter. Fields 'subscriptionId' and 'refundQuantity' are required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CommerceException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var2_2;
            Object object;
            com.intel.a.a.c c2 = new com.intel.a.a.c(Settings.getCommerceBaseURL() + "/subscriptions/{subscriptionId}/refund");
            c2.a("Content-Type", "application/json");
            c2.a("authorization", string);
            c2.c("subscriptionId", (String)object);
            object = new JSONObject();
            object.put("refundQuantity", (Object)var2_2);
            c2.a(object.toString());
            object = c2.a(3);
            if (object.b() != 201) {
                b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CommerceException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CommerceException("Error to perform this action", exception);
        }
    }
}

