/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.catalog;

import com.intel.a.a.c;
import com.intel.a.a.d;
import com.intel.api.Intel;
import com.intel.b.b;
import com.intel.common.Settings;
import com.intel.core.AccessToken;
import com.intel.core.auth.Auth;
import com.intel.core.catalog.CatalogItem;
import com.intel.core.catalog.CatalogIterator;
import com.intel.core.catalog.CatalogOption;
import com.intel.core.filter.FilterQuery;
import com.intel.exception.CatalogException;
import com.intel.exception.NotAuthenticatedException;
import com.intel.exception.RestException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogCollection {
    private String a;
    private String b;
    private JSONObject c;

    public CatalogCollection() {
    }

    /*
     * WARNING - void declaration
     */
    public CatalogCollection(JSONObject aCollection) throws JSONException {
        void var1_1;
        this.c = aCollection;
        this.a = aCollection.getString("datasetId");
        this.b = var1_1.getString("id");
    }

    public String getDatasetId() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setDatasetId(String datasetId) {
        void var1_1;
        this.a = var1_1;
    }

    public String getCollectionId() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void setCollectionId(String collectionId) {
        void var1_1;
        this.b = var1_1;
    }

    public CatalogItem getItemById(String itemId) throws CatalogException {
        Object object;
        String string;
        CatalogItem catalogItem = null;
        if (itemId == null || itemId.length() == 0) {
            throw new CatalogException("Invalid 'itemId' parameter. Must be a non-empty string.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        String string2 = "datasets/" + this.a;
        String string3 = "collections/" + this.b;
        object = "items/" + (String)object;
        object = new c(Settings.getCatalogBaseURL(), string2, string3, (String)object);
        ((c)object).a("Authorization", string);
        ((c)object).a("Content-Type", "application/json");
        try {
            object = ((c)object).a(1);
            if (((d)object).b() == 200) {
                catalogItem = new CatalogItem(((d)object).a().getJSONObject("data"));
            } else {
                com.intel.b.b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CatalogException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return catalogItem;
    }

    /*
     * WARNING - void declaration
     */
    public CatalogIterator getItems(FilterQuery filter, String fields, String orderby, Integer limit, Integer offset) throws CatalogException {
        void var3_3;
        void var2_2;
        void var1_1;
        CatalogOption catalogOption = new CatalogOption();
        catalogOption.setDatasetId(this.a);
        catalogOption.setCollectionId(this.b);
        catalogOption.setFilter((FilterQuery)var1_1);
        catalogOption.setFields((String)var2_2);
        catalogOption.setLimit(limit);
        catalogOption.setOffset(offset);
        catalogOption.setOrderby((String)var3_3);
        return this.getItems(catalogOption, null);
    }

    /*
     * WARNING - void declaration
     */
    public CatalogIterator getItems(CatalogOption optionPage, String link) throws CatalogException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            Object object2;
            if (object2 != null) {
                object2 = new c((String)object2);
            } else {
                object2 = "datasets/" + optionPage.getDatasetId();
                String string = "collections/" + optionPage.getCollectionId();
                String string2 = "items";
                object2 = new c(Settings.getCatalogBaseURL(), (String)object2, string, string2);
                if (optionPage.getFilter() != null) {
                    ((c)object2).b("$filter", optionPage.getFilter().toMongoDBString());
                }
                if (optionPage.getFields() != null) {
                    ((c)object2).b("$fields", optionPage.getFields());
                }
                if (optionPage.getLimit() != null) {
                    ((c)object2).b("$limit", String.valueOf(optionPage.getLimit()));
                }
                if (optionPage.getOffset() != null) {
                    ((c)object2).b("$offset", String.valueOf(optionPage.getOffset()));
                }
                if (optionPage.getOrderby() != null) {
                    ((c)object2).b("$orderby", optionPage.getOrderby());
                }
            }
            ((c)object2).a("Authorization", (String)object);
            ((c)object2).a("Content-Type", "application/json");
            object = ((c)object2).a(1, CatalogIterator.class);
            ((CatalogIterator)object).setOptionPage((CatalogOption)var1_1);
            ((CatalogIterator)object).setProvider(2);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return object;
    }

    public void removeItemById(String itemId) throws CatalogException {
        String string;
        if (itemId == null || itemId.length() == 0) {
            throw new CatalogException("The itemId is required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            String string2 = "datasets/" + this.a;
            String string3 = "collections/" + this.b;
            object = "items/" + (String)object;
            object = new c(Settings.getCatalogBaseURL(), string2, string3, (String)object);
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            object = ((c)object).a(4);
            if (((d)object).b() != 204) {
                com.intel.b.b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateItem(CatalogItem item) throws CatalogException {
        void var1_1;
        if (item == null) {
            throw new CatalogException("Invalid parameter. CatalogItem is required.");
        }
        ArrayList<CatalogItem> arrayList = new ArrayList<CatalogItem>();
        arrayList.add((CatalogItem)var1_1);
        this.updateItems(arrayList);
    }

    public void updateItems(List<CatalogItem> lstItems) throws CatalogException {
        String string;
        if (lstItems == null) {
            throw new CatalogException("Invalid parameter. Must be an object with required field 'itemsId'.");
        }
        if (lstItems.size() == 0) {
            throw new CatalogException("Invalid parameter. Must be a non-empty list of strings.");
        }
        for (CatalogItem catalogItem : lstItems) {
            if (catalogItem.getItemId() != null || catalogItem.getValue() != null) continue;
            throw new CatalogException("Invalid parameter. CatalogItem Must be an object with required field 'Id' and 'value'.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            Object object2;
            Object object32;
            JSONObject jSONObject;
            CatalogItem catalogItem;
            catalogItem = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (Object object32 : jSONObject) {
                object2 = new JSONObject();
                object2.put("id", (Object)((CatalogItem)object32).getItemId());
                object = ((CatalogItem)object32).getValue().optJSONObject("value");
                if (object == null) {
                    object = ((CatalogItem)object32).getValue();
                }
                object2.put("value", object);
                jSONArray.put(object2);
            }
            jSONObject2.put("items", (Object)jSONArray);
            catalogItem.put("data", jSONObject2);
            object32 = new StringBuilder();
            ((StringBuilder)object32).append(Settings.getCatalogBaseURL());
            ((StringBuilder)object32).append("/datasets/").append(this.a);
            ((StringBuilder)object32).append("/collections/").append(this.b);
            ((StringBuilder)object32).append("/items");
            object2 = new c(((StringBuilder)object32).toString());
            ((c)object2).a("Authorization", string);
            ((c)object2).a("Content-Type", "application/json");
            ((c)object2).a(catalogItem.toString());
            object = ((c)object2).a(3);
            if (((d)object).b() == 200) {
                jSONObject = ((d)object).a().getJSONObject("results");
                if (jSONObject.getInt("updated") == 0 && jSONObject.getInt("inserted") == 0) {
                    throw new CatalogException(jSONObject.getJSONArray("errors").toString());
                }
                return;
            }
            com.intel.b.b.a((d)object);
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    public void removeItems(List<String> itemsId) throws CatalogException {
        String string;
        if (itemsId == null) {
            throw new CatalogException("Invalid parameter. Must be an object with required field 'itemsId'.");
        }
        if (itemsId.size() == 0) {
            throw new CatalogException("Invalid parameter. Must be a non-empty list of strings.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            CharSequence charSequence;
            Object object2;
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                charSequence = (String)object2.next();
                object = new JSONObject();
                object.put("id", (Object)charSequence);
                jSONArray.put(object);
            }
            jSONObject2.put("items", (Object)jSONArray);
            jSONObject.put("data", (Object)jSONObject2);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(Settings.getCatalogBaseURL());
            ((StringBuilder)charSequence).append("/datasets/").append(this.a);
            ((StringBuilder)charSequence).append("/collections/").append(this.b);
            ((StringBuilder)charSequence).append("/items");
            object = new c(((StringBuilder)charSequence).toString());
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            ((c)object).a(jSONObject.toString());
            object2 = ((c)object).a(4);
            if (((d)object2).b() != 200) {
                com.intel.b.b.a((d)object2);
            }
            return;
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    public void uploadItem(List<CatalogItem> items) throws CatalogException {
        JSONArray jSONArray = new JSONArray();
        for (CatalogItem object : items) {
            jSONArray.put((Object)object.getValue());
        }
        jSONArray = this.a(null, jSONArray);
        for (int k = 0; k < items.size(); ++k) {
            items.remove(k);
            try {
                items.add(k, CatalogItem.getInternalItem(jSONArray.getJSONObject(k)));
                continue;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    private JSONArray a(String string, JSONArray object) throws CatalogException {
        String string2;
        string = null;
        try {
            string2 = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            JSONObject jSONObject = new JSONObject();
            Object object2 = new JSONObject();
            object2.put("items", object);
            jSONObject.put("data", object2);
            object = "datasets/" + this.a;
            object2 = "collections/" + this.b;
            String string3 = "items";
            object = new c(Settings.getCatalogBaseURL(), (String)object, (String)object2, string3);
            ((c)object).a("Authorization", string2);
            ((c)object).a("Content-Type", "application/json");
            ((c)object).a(jSONObject.toString());
            object = ((c)object).a(2);
            if (((d)object).b() != 201 && ((d)object).b() != 200) {
                com.intel.b.b.a((d)object);
            } else {
                string = ((d)object).a().getJSONObject("results").getJSONArray("items");
            }
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return string;
    }

    public JSONObject getContent() {
        return this.c;
    }
}

