/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.catalog;

import com.intel.a.a.c;
import com.intel.a.a.d;
import com.intel.api.Intel;
import com.intel.b.b;
import com.intel.common.Settings;
import com.intel.core.AccessToken;
import com.intel.core.auth.Auth;
import com.intel.core.catalog.CatalogCollection;
import com.intel.core.catalog.CatalogIterator;
import com.intel.core.catalog.CatalogOption;
import com.intel.core.catalog.Schema;
import com.intel.core.filter.Condition;
import com.intel.core.filter.Expression;
import com.intel.core.filter.FilterQuery;
import com.intel.exception.CatalogException;
import com.intel.exception.NotAuthenticatedException;
import com.intel.exception.RestException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogAdmin {
    public String createDataset(String name) throws CatalogException {
        String string;
        if (name == null || name.length() == 0) {
            throw new CatalogException("Invalid parameter. 'name' is required field.");
        }
        String string2 = null;
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("name", object);
            jSONObject.put("data", (Object)jSONObject2);
            object = new c(Settings.getCatalogBaseURL(), "datasets");
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            ((c)object).a(jSONObject.toString());
            object = ((c)object).a(2);
            if (((d)object).b() == 201) {
                object = ((d)object).a().getJSONObject("data");
                string2 = object.getString("id");
            } else {
                b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public CatalogCollection createCollection(String datasetId, String name, String schema) throws CatalogException {
        String string;
        CatalogCollection catalogCollection = null;
        if (datasetId == null || datasetId.length() == 0) {
            throw new CatalogException("The datasetId is required.");
        }
        if (name == null || name.length() == 0) {
            throw new CatalogException("The name is required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            void var3_3;
            void var2_2;
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("name", (Object)var2_2);
            jSONObject2.put("schema", (Object)var3_3);
            jSONObject.put("data", (Object)jSONObject2);
            object = new c(Settings.getCatalogBaseURL(), "datasets", (String)object, "collections");
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            ((c)object).a(jSONObject.toString());
            object = ((c)object).a(2);
            if (((d)object).b() == 201) {
                object = ((d)object).a().getJSONObject("data");
                catalogCollection = new CatalogCollection((JSONObject)object);
            } else {
                b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return catalogCollection;
    }

    public JSONObject getDatasetById(String datasetId) throws CatalogException {
        Object object;
        String string;
        JSONObject jSONObject = null;
        if (datasetId == null || datasetId.length() == 0) {
            throw new CatalogException("Invalid 'datasetId' parameter. Must be a non-empty string.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        object = new c(Settings.getCatalogBaseURL(), "datasets", (String)object);
        ((c)object).a("Authorization", string);
        ((c)object).a("Content-Type", "application/json");
        try {
            object = ((c)object).a(1);
            if (((d)object).b() == 200) {
                jSONObject = ((d)object).a();
            } else {
                b.a((d)object);
            }
        }
        catch (RestException restException) {
            throw new CatalogException(restException.getMessage());
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return jSONObject;
    }

    public CatalogIterator getDatasets() throws CatalogException {
        return this.getDatasets(new CatalogOption(null), null);
    }

    /*
     * WARNING - void declaration
     */
    public CatalogIterator getDatasets(CatalogOption optionPage, String link) throws CatalogException {
        Object object = null;
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            c c2;
            if (c2 != null) {
                c2 = new c((String)((Object)c2));
            } else {
                c2 = new c(Settings.getCatalogBaseURL(), "datasets", optionPage.getDatasetId());
                if (optionPage.getLimit() != null) {
                    c2.b("$limit", optionPage.getLimit().toString());
                }
                if (optionPage.getOffset() != null) {
                    c2.b("$offset", optionPage.getOffset().toString());
                }
            }
            c2.a("Authorization", (String)object);
            c2.a("Content-Type", "application/json");
            object = c2.a(1, CatalogIterator.class);
            ((CatalogIterator)object).setOptionPage((CatalogOption)var1_1);
            ((CatalogIterator)object).setProvider(0);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public CatalogIterator getCollections(String datasetId) throws CatalogException {
        void var1_1;
        return this.getCollections(new CatalogOption((String)var1_1, null), null);
    }

    /*
     * WARNING - void declaration
     */
    public CatalogIterator getCollections(CatalogOption optionPage, String link) throws CatalogException {
        Object object;
        Object object2 = null;
        if (optionPage.getDatasetId() == null || optionPage.getDatasetId().length() == 0) {
            throw new CatalogException("The datasetId is required.");
        }
        try {
            object2 = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            object = object != null ? new c((String)object) : new c(Settings.getCatalogBaseURL(), "datasets", optionPage.getDatasetId(), "collections");
            ((c)object).a("Authorization", (String)object2);
            ((c)object).a("Content-Type", "application/json");
            if (optionPage.getFilter() != null) {
                ((c)object).b("$filter", optionPage.getFilter().toMongoDBString());
            }
            if (optionPage.getLimit() != null) {
                ((c)object).b("$limit", optionPage.getLimit().toString());
            }
            if (optionPage.getOffset() != null) {
                ((c)object).b("$offset", optionPage.getOffset().toString());
            }
            object2 = ((c)object).a(1, CatalogIterator.class);
            ((CatalogIterator)object2).setOptionPage((CatalogOption)var1_1);
            ((CatalogIterator)object2).setProvider(1);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            throw new CatalogException("Error to perform this action", (Throwable)object);
        }
        return object2;
    }

    public void removeDatasetById(String datasetId) throws CatalogException {
        String string;
        if (datasetId == null) {
            throw new CatalogException("The datasetId is required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            object = new c(Settings.getCatalogBaseURL(), "datasets", (String)object);
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            object = ((c)object).a(4);
            if (((d)object).b() != 204) {
                b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    public void removeCollectionById(String datasetId, String collectionId) throws CatalogException {
        String string;
        if (datasetId == null || collectionId == null) {
            throw new CatalogException("The datasetId and collectionId are required.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            String string2;
            string2 = "collections/" + string2;
            object = new c(Settings.getCatalogBaseURL(), "datasets", (String)object, string2);
            ((c)object).a("Authorization", string);
            ((c)object).a("Content-Type", "application/json");
            object = ((c)object).a(4);
            if (((d)object).b() != 204) {
                b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CatalogCollection getCollectionByName(String datasetId, String collectionName) throws CatalogException {
        CatalogCollection catalogCollection = null;
        try {
            void var2_2;
            List<CatalogCollection> list;
            CatalogOption catalogOption = new CatalogOption();
            catalogOption.setDatasetId((String)((Object)list));
            list = new Expression();
            ((Expression)((Object)list)).setAttrOperValue("name", Expression.Operator.EQUAL, (String)var2_2);
            list = new FilterQuery((Condition)((Object)list));
            catalogOption.setFilter((FilterQuery)((Object)list));
            list = this.getCollections(catalogOption, null);
            list = ((CatalogIterator)((Object)list)).getCollections();
            if (list.size() > 0) {
                catalogCollection = list.get(0);
            }
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return catalogCollection;
    }

    /*
     * WARNING - void declaration
     */
    public void createPrivateSchema(Schema schema) throws CatalogException {
        Object object;
        if (schema == null || schema.getName() == null || schema.getName().length() == 0 || schema.getSchema() == null || schema.getSchema().length() == 0) {
            throw new CatalogException("Invalid parameter. Field 'name' and schema are required.");
        }
        if (schema.getName().indexOf(" ") != -1) {
            throw new CatalogException("Invalid name parameter. The schema name cannot contain any spaces.");
        }
        if (schema.getVisibility() != null && !schema.getVisibility().toLowerCase().equals("public") && !schema.getVisibility().toLowerCase().equals("private")) {
            throw new CatalogException("Invalid visibility parameter. Value must be 'public' or 'private'.");
        }
        try {
            object = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            void var1_1;
            Object object2 = Settings.getCatalogBaseURL() + "/schemas/private/me/" + schema.getName();
            object2 = new c((String)object2);
            ((c)object2).a("Authorization", (String)object);
            ((c)object2).a("Content-Type", "application/json");
            ((c)object2).a(schema.objectToJson().toString());
            object = ((c)object2).a(3);
            if (((d)object).b() != 201 && ((d)object).b() != 200) {
                b.a((d)object);
                return;
            }
            var1_1.jsonToObject(((d)object).a().getJSONObject("data"));
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    public List<Schema> getSchemas(String name, String visibility, Integer version) throws CatalogException {
        Object object;
        Object object2;
        ArrayList<Schema> arrayList = null;
        if (visibility != null && !visibility.toLowerCase().equals("public") && !visibility.toLowerCase().equals("private")) {
            throw new CatalogException("Invalid visibility parameter. Value must be 'public' or 'private'.");
        }
        Object object3 = new StringBuilder();
        if (name != null && name.length() > 0) {
            if (version != null && version <= 0) {
                throw new CatalogException("Field 'version' must be used with 'name' and Must be an integer greater than zero.");
            }
            ((StringBuilder)object3).append("/");
            ((StringBuilder)object3).append((String)object2);
            if (version != null) {
                ((StringBuilder)object3).append("/versions/");
                ((StringBuilder)object3).append(version);
            }
        } else if (object != null) {
            throw new CatalogException("Field 'version' must be used with 'name'.");
        }
        try {
            object2 = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object4;
            object = Settings.getCatalogBaseURL() + "/schemas/{visibility}/me" + object3;
            object = new c((String)object);
            ((c)object).a("Authorization", (String)object2);
            ((c)object).c("visibility", visibility != null ? object4.toLowerCase() : "private");
            object2 = ((c)object).a(1);
            if (((d)object2).b() != 200) {
                b.a((d)object2);
            } else {
                arrayList = new ArrayList<Schema>();
                if ((object2 = ((d)object2).a().getJSONObject("data")).has("items")) {
                    object4 = object2.getJSONArray("items");
                    for (int k = 0; k < object4.length(); ++k) {
                        object = object4.getJSONObject(k);
                        object3 = new Schema();
                        ((Schema)object3).jsonToObject((JSONObject)object);
                        arrayList.add((Schema)object3);
                    }
                } else {
                    object4 = new Schema();
                    object4.jsonToObject((JSONObject)object2);
                    arrayList.add((Schema)object4);
                }
            }
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
        return arrayList;
    }

    public void removePrivateSchemaByName(String schemaName) throws CatalogException {
        String string;
        if (schemaName == null || schemaName.length() == 0) {
            throw new CatalogException("Invalid 'schameName' parameter. Must be a non-empty string.");
        }
        if (schemaName.indexOf(" ") != -1) {
            throw new CatalogException("Invalid 'schameName' parameter. The schema name cannot contain any spaces.");
        }
        try {
            string = ((Auth)Intel.auth).a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            throw new CatalogException("Authentication required to perform this action", notAuthenticatedException);
        }
        try {
            Object object;
            object = Settings.getCatalogBaseURL() + "/schemas/private/me/" + (String)object;
            object = new c((String)object);
            ((c)object).a("Authorization", string);
            object = ((c)object).a(4);
            if (((d)object).b() != 204) {
                b.a((d)object);
            }
            return;
        }
        catch (RestException restException) {
            throw new CatalogException(restException);
        }
        catch (Exception exception) {
            throw new CatalogException("Error to perform this action", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updatePrivateSchema(Schema schema) throws CatalogException {
        void var1_1;
        this.createPrivateSchema((Schema)var1_1);
    }
}

