/*
 * Decompiled with CFR 0.152.
 */
package com.intel.core.auth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.intel.a.a.c;
import com.intel.a.a.d;
import com.intel.api.AuthAPI;
import com.intel.b.b;
import com.intel.common.Error;
import com.intel.common.Settings;
import com.intel.core.AccessToken;
import com.intel.core.Callback;
import com.intel.core.auth.LogoutCallback;
import com.intel.core.auth.a;
import com.intel.exception.ConnectionException;
import com.intel.exception.NotAuthenticatedException;
import com.intel.exception.RestException;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class Auth
implements AuthAPI {
    private static com.intel.a.b.a a = null;
    private Callback b = null;
    private boolean c = false;
    private Context d;

    public final synchronized Callback a() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final synchronized void init(Context appContext, Settings.Environment environment, String clientId2, String clientSecret, String scope, Callback callback) {
        void var3_7;
        void var1_1;
        this.d = appContext;
        a = com.intel.a.b.a.a((Context)appContext);
        if (a == null) {
            callback.onFail(new Error("Error trying to open application storage."));
            return;
        }
        if (environment != null) {
            void var2_2;
            Settings.setEnvironment(environment);
            a.a("environment", var2_2.toString());
        }
        if (clientId2 == null || clientSecret == null || scope == null || clientId2.length() == 0 || ((String)clientSecret).length() == 0 || scope.length() == 0) {
            callback.onFail(new Error(Error.Code.INVALID_PARAMETER, "The clientId, secretId and scope attributes are required."));
        }
        String string = a.a("client_id");
        String string2 = a.a("client_secret");
        String string3 = a.a("scope");
        if (string == null && string2 == null && string3 == null) {
            this.a(clientId2, (String)clientSecret, scope, (Callback)callback);
            return;
        }
        if (string != null && string.equals(clientId2) && string2 != null && string2.equals(clientSecret) && string3 != null && string3.equals(scope)) {
            String clientId2 = callback;
            AccessToken.AuthenticationType authenticationType = AccessToken.AuthenticationType.APP_AUTHORIZATION;
            appContext = this;
            if (Auth.b(authenticationType)) {
                if (authenticationType == AccessToken.AuthenticationType.APP_AUTHORIZATION) {
                    String string4 = a.a("client_id");
                    clientSecret = a.a("client_secret");
                    scope = a.a("scope");
                    super.a(string4, (String)clientSecret, scope, (Callback)((Object)clientId2));
                    return;
                }
                super.a((Callback)((Object)clientId2));
                return;
            }
            AccessToken.AuthenticationType authenticationType2 = authenticationType;
            appContext = clientId2;
            clientId2 = authenticationType2 == AccessToken.AuthenticationType.USER_AUTHENTICATION ? "_user" : "_app";
            clientSecret = new AccessToken();
            ((AccessToken)clientSecret).setAuthenticationType(authenticationType2);
            ((AccessToken)clientSecret).setExpiresIn(a.b("expires_in" + clientId2));
            ((AccessToken)clientSecret).setRefreshToken(a.a("refresh_token" + clientId2));
            ((AccessToken)clientSecret).setTokenType(a.a("token_type" + clientId2));
            ((AccessToken)clientSecret).setToken(a.a("token" + clientId2));
            appContext.onSuccess(clientSecret);
            return;
        }
        this.logout((Context)appContext, new LogoutCallback(this, (Context)var1_1, (String)var3_7, (String)clientSecret, scope, (Callback)callback){
            private /* synthetic */ Context a;
            private /* synthetic */ String b;
            private /* synthetic */ String c;
            private /* synthetic */ String d;
            private /* synthetic */ Callback e;
            private /* synthetic */ Auth f;
            {
                this.f = auth;
                this.a = context;
                this.b = string;
                this.c = string2;
                this.d = string3;
                this.e = callback;
            }

            public final void onSuccess() {
                this.f.a(this.b, this.c, this.d, this.e);
            }

            /*
             * WARNING - void declaration
             */
            public final void onFail(Error error) {
                void var1_1;
                this.e.onFail((Error)var1_1);
            }
        });
    }

    private void a(String string, String string2, String string3, Callback object) {
        object = new c(new Handler(this, string, string2, string3, (Callback)object){
            private /* synthetic */ String a;
            private /* synthetic */ String b;
            private /* synthetic */ String c;
            private /* synthetic */ Callback d;
            private /* synthetic */ Auth e;
            {
                this.e = auth;
                this.a = string;
                this.b = string2;
                this.c = string3;
                this.d = callback;
            }

            public final void handleMessage(Message msg) {
                block5: {
                    try {
                        d d2 = (d)msg.obj;
                        if (d2.b() == 200) {
                            d2 = d2.a().getJSONObject("OAuth20").getJSONObject("access_token");
                            String string = "json " + d2;
                            Log.d((String)"CspAndroid", (String)string);
                            a.a("client_id", this.a);
                            a.a("client_secret", this.b);
                            a.a("scope", this.c);
                            this.e.setAccessToken(AccessToken.AuthenticationType.APP_AUTHORIZATION, (JSONObject)d2, this.d);
                            break block5;
                        }
                        try {
                            com.intel.b.b.a(d2);
                        }
                        catch (Exception exception) {
                            this.d.onFail(new Error(exception.getMessage()));
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.d.onFail(new Error(Error.Code.INTERNAL_ERROR, "Error trying to obtain or save two legged token"));
                        exception.printStackTrace();
                        String string = "Error " + exception.getMessage();
                        Log.d((String)"CspAndroid", (String)string);
                    }
                }
            }
        }, Settings.getAuthURL(), 1);
        ((c)object).b("client_id", string);
        ((c)object).b("client_secret", string2);
        ((c)object).b("scope", string3);
        ((c)object).b("grant_type", "client_credentials");
        ((c)object).a();
    }

    private static void a(AccessToken accessToken) throws Exception {
        if (a != null) {
            Long l = new Date().getTime() + (long)(accessToken.getExpiresIn() * 1000);
            String string = accessToken.getAuthenticationType() == AccessToken.AuthenticationType.USER_AUTHENTICATION ? "_user" : "_app";
            a.a("token" + string, accessToken.getToken());
            a.a("refresh_token" + string, accessToken.getRefreshToken());
            a.a("expires_in" + string, accessToken.getExpiresIn());
            a.a("type" + string, accessToken.getTokenType());
            a.a("token_expiration" + string, String.valueOf(l));
            a.a("authentication_type", accessToken.getAuthenticationType().toString());
            return;
        }
        throw new Exception("Error trying to store TokenData");
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void login(Context appContext, Provider provider, String redirectUri, Action action, Callback callback) {
        a = com.intel.a.b.a.a(appContext);
        if (a == null) {
            callback.onFail(new Error("Error trying to open application storage."));
            return;
        }
        String string = a.a("client_id");
        String string2 = a.a("client_secret");
        String string3 = a.a("scope");
        if (string != null && string2 != null && string3 != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.login((Context)var1_1, null, null, string, string2, string3, (Provider)var2_2, (String)var3_3, action, callback);
            return;
        }
        callback.onFail(new Error(Error.Code.NO_TOKEN, "Unable to get clientId, secret and scope. Did you execute init first?"));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void login(Context appContext, Settings.Environment environment, String locale, String clientId, String clientSecret, String scope, Provider provider, String redirectUri, Action action, Callback callback) {
        IntentFilter intentFilter;
        Object object;
        this.d = appContext;
        a = com.intel.a.b.a.a(appContext);
        if (environment != null) {
            Settings.setEnvironment(environment);
            a.a("environment", ((Enum)object).toString());
        }
        if (appContext == null || clientId == null || clientId.length() == 0 || clientSecret == null || clientSecret.length() == 0 || scope == null || scope.length() == 0) {
            object = "Empty parameters in login method";
            Log.d((String)"CspAndroid", (String)object);
            callback.onFail(new Error(Error.Code.INVALID_PARAMETER, "Parameters should not be empty"));
            return;
        }
        this.b = callback;
        if (a != null) {
            a.a("client_id", clientId);
            a.a("client_secret", clientSecret);
            object = appContext.getResources().getConfiguration().locale;
            if (locale == null) {
                locale = a.a("locale") != null ? a.a("locale") : (object != null ? ((Locale)object).getLanguage() + "-" + ((Locale)object).getCountry() : "en-US");
            }
        } else {
            callback.onFail(new Error("Error trying to open application storage."));
            return;
        }
        a.a("locale", locale);
        object = false;
        String string = appContext.getPackageName();
        String string2 = "com.intel.core.ui.LoginActivity";
        try {
            intentFilter = appContext.getPackageManager().getPackageInfo(string, 5);
            for (ActivityInfo activityInfo : intentFilter.activities) {
                if (!activityInfo.name.equals(string2)) continue;
                object = "LoginActivity found on AndroidManifest.xml";
                Log.d((String)"CspAndroid", (String)object);
                object = true;
                break;
            }
            if (!((Boolean)object).booleanValue()) {
                Auth.b();
                object = "No LoginActivity declared on AndroidManifest.xml!";
                Log.d((String)"CspAndroid", (String)object);
                callback.onFail(new Error("LoginActivity not found, did you declared it on AndroidManifest.xml?"));
                return;
            }
            intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            com.intel.a.a.a a2 = new com.intel.a.a.a();
            appContext.registerReceiver((BroadcastReceiver)a2, intentFilter);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            Auth.b();
            callback.onFail(new Error("Error trying to read application package. Check context parameter passed on login method."));
            return;
        }
        try {
            void var1_1;
            void var3_3;
            intentFilter = new Intent();
            intentFilter.setClassName(string, string2);
            intentFilter.addFlags(0x10000000);
            intentFilter.putExtra("client_id", clientId);
            intentFilter.putExtra("client_secret", clientSecret);
            intentFilter.putExtra("scope", scope);
            intentFilter.putExtra("locale", (String)var3_3);
            intentFilter.putExtra("action", action == null ? "signin" : action.toString());
            if (provider != null) {
                intentFilter.putExtra("provider", provider.toString().toLowerCase());
            }
            intentFilter.putExtra("redirect_uri", redirectUri);
            var1_1.startActivity((Intent)intentFilter);
            return;
        }
        catch (Exception exception) {
            Auth.b();
            callback.onFail(new Error("Error trying to open login popup"));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final synchronized void logout(Context appContext, LogoutCallback callBack) {
        c c2;
        a = com.intel.a.b.a.a(appContext);
        if (a == null) {
            c2.onFail(new Error(Error.Code.NO_TOKEN, "You must Authorize your application or Log in your user."));
            return;
        }
        String string = a.a("client_id");
        if (string != null) {
            c2 = new c(new Handler(this, callBack){
                private /* synthetic */ LogoutCallback a;
                private /* synthetic */ Auth b;
                {
                    this.b = auth;
                    this.a = logoutCallback;
                }

                public final void handleMessage(Message msg) {
                    block5: {
                        Object object;
                        try {
                            object = (d)msg.obj;
                            if (((d)object).b() == 200) {
                                3 v0 = this;
                                v0.b.b();
                                this.a.onSuccess();
                                break block5;
                            }
                            try {
                                com.intel.b.b.a((d)object);
                            }
                            catch (Exception exception) {
                                3 v1 = this;
                                v1.b.b();
                                this.a.onFail(new Error(Error.Code.INTERNAL_ERROR, exception.getMessage()));
                                return;
                            }
                        }
                        catch (Exception exception) {
                            object = exception;
                            exception.printStackTrace();
                            3 v3 = this;
                            v3.b.b();
                            this.a.onFail(new Error(Error.Code.INTERNAL_ERROR, "Error trying to logout"));
                        }
                    }
                }
            }, Settings.getLogoutURL(), 1);
            c2.b("clientIdentifier", string);
            c2.a();
            return;
        }
        Auth.b();
        c2.onSuccess();
    }

    public static void b() {
        a.c("token_user");
        a.c("refresh_token_user");
        a.c("expires_in_user");
        a.c("type_user");
        a.c("token_app");
        a.c("refresh_token_app");
        a.c("expires_in_app");
        a.c("type_app");
        a.c("authentication_type");
        a.c("user_id");
        a.c("token_expiration_user");
        a.c("token_expiration_app");
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized AccessToken getAccessToken(AccessToken.AuthenticationType authenticationType) throws NotAuthenticatedException, ConnectionException {
        if (a != null) {
            Object object;
            Object object2 = "_app";
            if (authenticationType != null && authenticationType.equals((Object)AccessToken.AuthenticationType.USER_AUTHENTICATION)) {
                object2 = "_user";
                if (this.d != null && this.isLoggedIn(this.d).booleanValue() && Auth.b(authenticationType)) {
                    return this.d();
                }
            }
            int n = 0;
            while (this.c) {
                try {
                    Thread.sleep(1000L);
                    if (++n != 120) continue;
                    break;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                }
            }
            if (n == 120) {
                throw new ConnectionException("Error to connect with the server.");
            }
            object = a.a("token" + (String)object2);
            String string = a.a("refresh_token" + (String)object2);
            String string2 = a.a("expires_in" + (String)object2);
            String string3 = a.a("type" + (String)object2);
            String string4 = "token " + (String)object;
            Log.d((String)"CspAndroid", (String)string4);
            string4 = "refreshToken " + string;
            Log.d((String)"CspAndroid", (String)string4);
            string4 = "expiresIn " + string2;
            Log.d((String)"CspAndroid", (String)string4);
            string4 = "type " + string3;
            Log.d((String)"CspAndroid", (String)string4);
            string4 = "tag " + (String)object2;
            Log.d((String)"CspAndroid", (String)string4);
            if (object != null && string != null && string2 != null && string3 != null && authenticationType != null) {
                void var1_1;
                object2 = new AccessToken();
                ((AccessToken)object2).setToken((String)object);
                ((AccessToken)object2).setRefreshToken(string);
                ((AccessToken)object2).setExpiresIn(Integer.valueOf(string2));
                ((AccessToken)object2).setTokenType(string3);
                ((AccessToken)object2).setAuthenticationType((AccessToken.AuthenticationType)var1_1);
                return object2;
            }
            throw new NotAuthenticatedException();
        }
        throw new NotAuthenticatedException();
    }

    private AccessToken d() {
        AccessToken accessToken = null;
        Object object = a.a("refresh_token_user");
        String string = a.a("client_id");
        String string2 = a.a("client_secret");
        c c2 = new c(Settings.getRefreshTokenURL());
        c2.a("Content-Type", "application/x-www-form-urlencoded");
        c2.b("refresh_token", (String)object);
        c2.b("client_id", string);
        c2.b("client_secret", string2);
        c2.b("grant_type", "refresh_token");
        try {
            object = c2.a(2);
            if (((d)object).b() == 200) {
                accessToken = new AccessToken(AccessToken.AuthenticationType.USER_AUTHENTICATION, ((d)object).a());
                Auth.a(accessToken);
                return accessToken;
            }
            com.intel.b.b.a((d)object);
        }
        catch (Exception exception) {
            object = exception;
            object = exception.getMessage();
            Log.e((String)"CspAndroid", (String)object);
        }
        return accessToken;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void getAccessToken(Context appContext, Callback callback) {
        void var2_3;
        a = com.intel.a.b.a.a(appContext);
        if (a == null) {
            callback.onFail(new Error(Error.Code.NO_TOKEN, "Tokens not available. Please, you need to invoke the init or login method previously"));
            return;
        }
        String string = a.a("token_user");
        String string2 = a.a("refresh_token_user");
        String string3 = a.a("expires_in_user");
        String string4 = a.a("type_user");
        String string5 = a.a("authentication_type");
        if (string != null && string2 != null && string3 != null && string4 != null && string5 != null) {
            void var1_1;
            AccessToken accessToken = new AccessToken();
            accessToken.setToken(string);
            accessToken.setRefreshToken(string2);
            accessToken.setExpiresIn(Integer.valueOf(string3));
            accessToken.setTokenType(string4);
            accessToken.setAuthenticationType(AccessToken.AuthenticationType.valueOf(string5));
            if (this.isLoggedIn((Context)var1_1).booleanValue()) {
                try {
                    if (Auth.b(accessToken.getAuthenticationType())) {
                        this.a(callback);
                    }
                }
                catch (Exception exception) {
                    callback.onFail(new Error(exception.getMessage()));
                }
            }
            callback.onSuccess(accessToken);
            return;
        }
        var2_3.onFail(new Error(Error.Code.NO_TOKEN, "No token available, please call login"));
    }

    private static boolean b(AccessToken.AuthenticationType object) {
        try {
            object = object == AccessToken.AuthenticationType.USER_AUTHENTICATION ? a.a("token_expiration_user") : a.a("token_expiration_app");
            if (object != null) {
                object = Long.parseLong((String)object);
                Long l = new Date().getTime();
                return l > (Long)object;
            }
            return true;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            object = ((Throwable)object).getMessage();
            Log.e((String)"CspAndroid", (String)object);
            return false;
        }
    }

    private void a(Callback object) {
        String string = a.a("refresh_token_user");
        String string2 = a.a("client_id");
        String string3 = a.a("client_secret");
        String string4 = "refresh3LToken ";
        Log.d((String)"CspAndroid", (String)string4);
        string4 = "refreshToken " + string;
        Log.d((String)"CspAndroid", (String)string4);
        string4 = "clientId " + string2;
        Log.d((String)"CspAndroid", (String)string4);
        string4 = "clientSecret " + string3;
        Log.d((String)"CspAndroid", (String)string4);
        if (string != null && string2 != null && string3 != null) {
            object = new c(new Handler(this, (Callback)object){
                private /* synthetic */ Callback a;
                private /* synthetic */ Auth b;
                {
                    this.b = auth;
                    this.a = callback;
                }

                public final void handleMessage(Message msg) {
                    block5: {
                        Object object;
                        try {
                            object = (d)msg.obj;
                            if (object != null && ((d)object).b() == 200) {
                                Auth.a(this.b, false);
                                this.b.setAccessToken(AccessToken.AuthenticationType.USER_AUTHENTICATION, ((d)object).a(), this.a);
                                break block5;
                            }
                            try {
                                com.intel.b.b.a((d)object);
                            }
                            catch (Exception exception) {
                                this.a.onFail(new Error(exception.getMessage()));
                                return;
                            }
                        }
                        catch (Exception exception) {
                            object = exception;
                            exception.printStackTrace();
                            this.a.onFail(new Error(Error.Code.NO_TOKEN, "No token available, please call login"));
                        }
                    }
                }
            }, Settings.getRefreshTokenURL(), 2);
            ((c)object).a("Content-Type", "application/x-www-form-urlencoded");
            ((c)object).b("refresh_token", string);
            ((c)object).b("client_id", string2);
            ((c)object).b("client_secret", string3);
            ((c)object).b("grant_type", "refresh_token");
            ((c)object).a();
            return;
        }
        object.onFail(new Error(Error.Code.NO_TOKEN, "Tokens not available. Please, you need to invoke the init or login methods previously"));
    }

    public final synchronized Boolean isAppAuthorized() {
        String string;
        if (a != null && (string = a.a("token_app")) != null) {
            return true;
        }
        return false;
    }

    public final synchronized Boolean isLoggedIn(Context appContext) {
        Object object;
        this.d = appContext;
        boolean bl = false;
        if (a == null) {
            bl = true;
            a = com.intel.a.b.a.a((Context)object);
        }
        if (a != null) {
            object = a.a("environment");
            if (bl && object != null) {
                Settings.setEnvironment(Settings.Environment.valueOf(object));
            }
            if ((object = a.a("authentication_type")) != null && ((Enum)(object = AccessToken.AuthenticationType.valueOf(object))).equals((Object)AccessToken.AuthenticationType.USER_AUTHENTICATION)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void refreshToken(Context appContext, Callback callback) {
        void var2_2;
        if (a != null) {
            String string;
            if (this.isLoggedIn((Context)string).booleanValue()) {
                this.a(callback);
                return;
            }
            if (this.isAppAuthorized().booleanValue()) {
                string = a.a("client_id");
                String string2 = a.a("client_secret");
                String string3 = a.a("scope");
                this.a(string, string2, string3, callback);
                return;
            }
            callback.onFail(new Error(Error.Code.NO_TOKEN, "Unable to refresh token. Not authenticated."));
            return;
        }
        var2_2.onFail(new Error(Error.Code.NO_TOKEN, "Unable to access app storage. Not authenticated."));
    }

    public final synchronized String a(AccessToken.AuthenticationType object) throws NotAuthenticatedException {
        AccessToken accessToken;
        try {
            accessToken = this.getAccessToken((AccessToken.AuthenticationType)((Object)object));
        }
        catch (ConnectionException connectionException) {
            object = connectionException;
            connectionException.printStackTrace();
            throw new NotAuthenticatedException((Throwable)object);
        }
        if (accessToken != null) {
            String string = "TYPE:" + (Object)((Object)accessToken.getAuthenticationType());
            Log.d((String)"CspAndroid", (String)string);
            if (accessToken.getAuthenticationType().compareTo(object) < 0) {
                throw new NotAuthenticatedException();
            }
            object = "Bearer " + accessToken.getToken();
            string = "authorization:" + (String)object;
            Log.d((String)"CspAndroid", (String)string);
            return object;
        }
        throw new NotAuthenticatedException();
    }

    public final void getApplicationInstance(Context object, Callback callback) {
        c c2;
        try {
            object = this.a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            callback.onFail(new Error(Error.Code.NO_TOKEN, "The access token for authentication type requested does not exist."));
            return;
        }
        c2 = new c(new Handler(this, (Callback)((Object)c2)){
            private /* synthetic */ Callback a;
            {
                this.a = callback;
            }

            public final void handleMessage(Message msg) {
                Object object = (d)msg.obj;
                if (((d)object).b() == 200) {
                    try {
                        object = ((d)object).a().getString("instance");
                        this.a.onSuccess(object);
                        return;
                    }
                    catch (JSONException jSONException) {
                        object = jSONException;
                        jSONException.printStackTrace();
                        this.a.onFail(new Error(object.getMessage()));
                        return;
                    }
                }
                try {
                    com.intel.b.b.a((d)object);
                    return;
                }
                catch (RestException restException) {
                    this.a.onFail(new Error(restException.getMessage()));
                    return;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                    this.a.onFail(new Error(((Throwable)object).getMessage()));
                    return;
                }
            }
        }, Settings.getApplicationInstanceURL(), 1);
        c2.a("Authorization", (String)object);
        c2.a();
    }

    public final void getTokenInfo(Context object, Callback callback) {
        c c2;
        try {
            object = this.a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            callback.onFail(new Error(Error.Code.NO_TOKEN, "The access token for authentication type requested does not exist."));
            return;
        }
        c2 = new c(new Handler(this, (Callback)((Object)c2)){
            private /* synthetic */ Callback a;
            {
                this.a = callback;
            }

            public final void handleMessage(Message msg) {
                Object object = (d)msg.obj;
                if (((d)object).b() == 200) {
                    try {
                        object = new a(((d)object).a());
                        this.a.onSuccess(object);
                        return;
                    }
                    catch (JSONException jSONException) {
                        object = jSONException;
                        jSONException.printStackTrace();
                        this.a.onFail(new Error(object.getMessage()));
                        return;
                    }
                }
                try {
                    com.intel.b.b.a((d)object);
                    return;
                }
                catch (RestException restException) {
                    this.a.onFail(new Error(restException.getMessage()));
                    return;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                    this.a.onFail(new Error(((Throwable)object).getMessage()));
                    return;
                }
            }
        }, Settings.getTokenInfoUrl(), 1);
        c2.a("Authorization", (String)object);
        c2.a();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccessToken(AccessToken.AuthenticationType type, JSONObject token, Callback callback) {
        Object object;
        try {
            void var2_2;
            object = new AccessToken((AccessToken.AuthenticationType)((Object)object), (JSONObject)var2_2);
            Auth.a((AccessToken)object);
            callback.onSuccess(object);
            return;
        }
        catch (Exception exception) {
            void var3_3;
            object = exception;
            exception.printStackTrace();
            var3_3.onFail(new Error(Error.Code.INTERNAL_ERROR, "Error to perform this action"));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void getSocialToken(Context object, Provider provider, Callback callback) {
        void var3_3;
        Object object2;
        if (provider == null) {
            callback.onFail(new Error(Error.Code.INVALID_PARAMETER, "Provider is requerid"));
            return;
        }
        try {
            object = this.a(AccessToken.AuthenticationType.USER_AUTHENTICATION);
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            callback.onFail(new Error(Error.Code.NO_TOKEN, "The access token for authentication type requested does not exist."));
            return;
        }
        object2 = Settings.getSocialTokenUrl() + ((Enum)object2).toString().toLowerCase();
        object2 = new c(new Handler(this, (Callback)var3_3){
            private /* synthetic */ Callback a;
            {
                this.a = callback;
            }

            public final void handleMessage(Message msg) {
                Object object;
                try {
                    object = (d)msg.obj;
                    if (((d)object).b() != 200) {
                        com.intel.b.b.a((d)object);
                        return;
                    }
                    object = new AccessToken(AccessToken.AuthenticationType.USER_AUTHENTICATION, ((d)object).a());
                    this.a.onSuccess(object);
                }
                catch (RestException restException) {
                    this.a.onFail(new Error(restException.getMessage()));
                    return;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                    this.a.onFail(new Error(((Throwable)object).getMessage()));
                }
            }
        }, (String)object2, 1);
        ((c)object2).a("Authorization", (String)object);
        ((c)object2).a();
    }

    static /* synthetic */ boolean a(Auth auth, boolean bl) {
        auth.c = false;
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Provider implements Parcelable
    {
        INTEL,
        GOOGLE,
        FACEBOOK,
        YAHOO;

        public static final Parcelable.Creator<Provider> CREATOR;

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel dest, int n) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<Provider>(){

                public final /* synthetic */ Object createFromParcel(Parcel x0) {
                    Parcel parcel = x0;
                    return Provider.values()[parcel.readInt()];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        SIGN_IN("signin"),
        CREATE("create");

        private final String a;

        /*
         * WARNING - void declaration
         */
        private Action(String text) {
            void var3_3;
            this.a = var3_3;
        }

        public final String toString() {
            return this.a;
        }
    }
}

