/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.statemanager.itemhelpers;

import com.intel.context.item.Item;
import com.intel.context.item.historical.Search;
import com.intel.context.item.historical.common.Point;
import com.intel.context.statemanager.itemhelpers.BaseHelper;
import org.json.JSONException;
import org.json.JSONObject;

public final class SearchHelper
extends BaseHelper {
    private SearchHelper() {
    }

    public static boolean isStateItem() {
        return false;
    }

    public static boolean isHistoricalItem() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void fromJson(Item item, String jsonString) {
        void var1_1;
        SearchHelper.fromHistorical(item, "{\"value\":" + (String)var1_1 + "}");
    }

    public static String toJson(Item item) {
        return SearchHelper.getHistoricalValue(item);
    }

    public static String getHistoricalValue(Item item) {
        Item item2 = (Search)item;
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            Point point = ((Search)item2).getLocation();
            if (point == null || point.getLat() == 0.0 || point.getLon() == 0.0) {
                throw new IllegalArgumentException("Not all mandatory attributes has been filled.");
            }
            jSONObject2.put("lat", point.getLat());
            jSONObject2.put("lon", point.getLon());
            jSONObject.put("location", (Object)jSONObject2);
            if (((Search)item2).getName() != null) {
                jSONObject.put("name", (Object)((Search)item2).getName());
            }
            if (((Search)item2).getSourceDomain() != null) {
                jSONObject.put("source_domain", (Object)((Search)item2).getSourceDomain());
            }
            if (((Search)item2).getValue() != null) {
                jSONObject.put("value", (Object)((Search)item2).getValue());
            }
            if (((Search)item2).getType() != null) {
                jSONObject.put("type", (Object)((Search)item2).getType());
            }
            if (item2.getDateTime() != null) {
                jSONObject.put("datetime", (Object)item2.getDateTime());
            }
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.getMessage());
        }
        return jSONObject.toString();
    }

    public static String getHistoricalExtension(Item item) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fromHistorical(Item item, String jsonString) {
        Item item2;
        if (!(item instanceof Search)) throw new IllegalArgumentException("Wrong type of item: " + item2.getClass().getSimpleName());
        item2 = (Search)item;
        try {
            JSONObject jSONObject;
            jSONObject = new JSONObject((String)jSONObject);
            jSONObject = jSONObject.getJSONObject("value");
            JSONObject jSONObject2 = jSONObject.getJSONObject("location");
            Point point = new Point(jSONObject2.getDouble("lat"), jSONObject2.getDouble("lon"));
            ((Search)item2).setLocation(point);
            if (jSONObject.has("name")) {
                ((Search)item2).setName(jSONObject.getString("name"));
            }
            if (jSONObject.has("source_domain")) {
                ((Search)item2).setSourceDomain(jSONObject.getString("source_domain"));
            }
            if (jSONObject.has("value")) {
                ((Search)item2).setValue(jSONObject.getString("value"));
            }
            if (!jSONObject.has("type")) return;
            ((Search)item2).setType(jSONObject.getString("type"));
            return;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.getMessage());
        }
    }
}

