/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.statemanager.itemhelpers;

import com.intel.context.item.Item;
import com.intel.context.item.historical.Route;
import com.intel.context.item.historical.common.Point;
import com.intel.context.item.historical.route.Milestone;
import com.intel.context.statemanager.itemhelpers.BaseHelper;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RouteHelper
extends BaseHelper {
    private RouteHelper() {
    }

    public static boolean isStateItem() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void fromJson(Item item, String jsonString) {
        void var1_1;
        RouteHelper.fromHistorical(item, "{\"value\":" + (String)var1_1 + "}");
    }

    public static String toJson(Item item) {
        return RouteHelper.getHistoricalValue(item);
    }

    public static boolean isHistoricalItem() {
        return true;
    }

    public static String getHistoricalValue(Item item) {
        Item item2 = (Route)item;
        JSONObject jSONObject = new JSONObject();
        try {
            if (((Route)item2).getOrigin() == null || ((Route)item2).getOrigin().getLocation().getLat() == 0.0 || ((Route)item2).getOrigin().getLocation().getLon() == 0.0) {
                throw new IllegalArgumentException("Not all mandatory attributes has been filled.");
            }
            JSONObject jSONObject2 = new JSONObject();
            Object object = new JSONObject();
            object.put("lat", ((Route)item2).getOrigin().getLocation().getLat());
            object.put("lon", ((Route)item2).getOrigin().getLocation().getLon());
            jSONObject2.put("location", object);
            jSONObject2.put("datetime", (Object)((Route)item2).getOrigin().getDatetime());
            jSONObject.put("origin", (Object)jSONObject2);
            if (((Route)item2).getDestination() == null || ((Route)item2).getDestination().getLocation().getLat() == 0.0 || ((Route)item2).getDestination().getLocation().getLon() == 0.0) {
                throw new IllegalArgumentException("Not all mandatory attributes has been filled.");
            }
            jSONObject2 = new JSONObject();
            object = new JSONObject();
            jSONObject2.put("lat", ((Route)item2).getDestination().getLocation().getLat());
            jSONObject2.put("lon", ((Route)item2).getDestination().getLocation().getLon());
            object.put("location", (Object)jSONObject2);
            object.put("datetime", (Object)((Route)item2).getDestination().getDatetime());
            jSONObject.put("destination", object);
            if (((Route)item2).getRouteAlgorithm() != null) {
                jSONObject.put("routeAlgorithm", (Object)((Route)item2).getRouteAlgorithm().toString());
            }
            if (((Route)item2).getAvoid().size() != 0) {
                jSONObject2 = new JSONArray();
                for (Route.RoadType object2 : ((Route)item2).getAvoid()) {
                    jSONObject2.put((Object)object2.toString());
                }
                jSONObject.put("avoid", (Object)jSONObject2);
            }
            jSONObject.put("zoom", ((Route)item2).getZoom());
            if (((Route)item2).getPreferred().size() != 0) {
                jSONObject2 = new JSONArray();
                for (Route.RoadType roadType : ((Route)item2).getPreferred()) {
                    jSONObject2.put((Object)roadType.toString());
                }
                jSONObject.put("preferred", (Object)jSONObject2);
            }
            if (((Route)item2).getMeasurement() != null) {
                jSONObject.put("measurement", (Object)((Route)item2).getMeasurement().toString());
            }
            if (((Route)item2).getAlt() != null) {
                jSONObject.put("alt", (Object)((Route)item2).getAlt());
            }
            if (((Route)item2).isTrafficAware() != null) {
                jSONObject.put("trafficAware", (Object)((Route)item2).isTrafficAware());
            }
            if (((Route)item2).getViaPoints().size() != 0) {
                jSONObject2 = new JSONArray();
                for (Point point : ((Route)item2).getViaPoints()) {
                    item2 = new JSONObject();
                    item2.put("lat", point.getLat());
                    item2.put("lon", point.getLon());
                    jSONObject2.put((Object)item2);
                }
                jSONObject.put("viaPoints", (Object)jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.getMessage());
        }
        return jSONObject.toString();
    }

    public static String getHistoricalExtension(Item item) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fromHistorical(Item item, String jsonString) {
        Item item2;
        if (!(item instanceof Route)) throw new IllegalArgumentException("Wrong type of item: " + item2.getClass().getSimpleName());
        item2 = (Route)item;
        try {
            int n;
            JSONObject jSONObject;
            jSONObject = new JSONObject((String)jSONObject);
            jSONObject = jSONObject.getJSONObject("value");
            JSONObject jSONObject2 = jSONObject.getJSONObject("origin");
            Object object = jSONObject2.getJSONObject("location");
            String string = jSONObject2.getString("datetime");
            ((Route)item2).setOrigin(new Milestone(string, new Point(object.getDouble("lat"), object.getDouble("lon"))));
            JSONObject jSONObject3 = jSONObject.getJSONObject("destination");
            object = jSONObject3.getJSONObject("location");
            String string2 = jSONObject3.getString("datetime");
            ((Route)item2).setDestination(new Milestone(string2, new Point(object.getDouble("lat"), object.getDouble("lon"))));
            if (jSONObject.has("routeAlgorithm")) {
                ((Route)item2).setRouteAlgorithm(Route.RouteAlgorithm.valueOf(jSONObject.getString("routeAlgorithm")));
            }
            if (jSONObject.has("avoid")) {
                JSONArray jSONArray = jSONObject.getJSONArray("avoid");
                object = new ArrayList();
                for (n = 0; n < jSONArray.length(); ++n) {
                    object.add(Route.RoadType.valueOf(jSONArray.getString(n)));
                }
                ((Route)item2).setAvoid((List<Route.RoadType>)object);
            }
            if (jSONObject.has("zoom")) {
                ((Route)item2).setZoom(jSONObject.getInt("zoom"));
            }
            if (jSONObject.has("preferred")) {
                JSONArray jSONArray = jSONObject.getJSONArray("preferred");
                object = new ArrayList();
                for (n = 0; n < jSONArray.length(); ++n) {
                    object.add(Route.RoadType.valueOf(jSONArray.getString(n)));
                }
                ((Route)item2).setPreferred((List<Route.RoadType>)object);
            }
            if (jSONObject.has("measurement")) {
                ((Route)item2).setMeasurement(Route.MeasureSystem.valueOf(jSONObject.getString("measurement")));
            }
            if (jSONObject.has("alt")) {
                ((Route)item2).setAlt(jSONObject.getString("alt"));
            }
            if (jSONObject.has("trafficAware")) {
                ((Route)item2).isTrafficAware(jSONObject.getBoolean("trafficAware"));
            }
            if (!jSONObject.has("viaPoints")) return;
            JSONArray jSONArray = jSONObject.getJSONArray("viaPoints");
            object = new ArrayList();
            for (n = 0; n < jSONArray.length(); ++n) {
                jSONObject = jSONArray.getJSONObject(n);
                object.add(new Point(jSONObject.getDouble("lat"), jSONObject.getDouble("lon")));
            }
            ((Route)item2).setViaPoints((List<Point>)object);
            return;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.getMessage());
        }
    }
}

