/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.statemanager.itemhelpers;

import com.intel.context.item.Item;
import com.intel.context.item.Network;
import com.intel.context.item.network.NetworkInformation;
import com.intel.context.statemanager.itemhelpers.BaseHelper;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkHelper
extends BaseHelper {
    private NetworkHelper() {
    }

    public static boolean isStateItem() {
        return true;
    }

    public static boolean isHistoricalItem() {
        return false;
    }

    public static String toJson(Item item) {
        JSONObject jSONObject;
        Object object;
        if (item instanceof Network) {
            object = (Network)item;
            jSONObject = new JSONObject();
            try {
                jSONObject.put("ip", (Object)((Network)object).getIp());
                jSONObject.put("phoneType", (Object)((Network)object).getPhoneType());
                jSONObject.put("cellLocation", (Object)((Network)object).getCellLocation());
                jSONObject.put("linkSpeed", ((Network)object).getLinkSpeed());
                jSONObject.put("networkType", (Object)((Network)object).getNetworkType());
                jSONObject.put("securityType", (Object)((Network)object).getSecurityType());
                jSONObject.put("ssid", (Object)((Network)object).getSsid());
                jSONObject.put("nearNetworks", (Object)NetworkHelper.a(((Network)object).getNearNetworks()));
                jSONObject.put("signalStrength", (Object)((Network)object).getSignalStrength());
                jSONObject.put("roamingActive", ((Network)object).getRoamingActive());
                jSONObject.put("trafficReceived", (double)((Network)object).getTrafficReceived());
                jSONObject.put("trafficSent", (double)((Network)object).getTrafficSent());
                jSONObject.put("onlineTime", ((Network)object).getOnlineTime());
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Wrong type of item: " + object.getClass().getSimpleName());
        }
        object = jSONObject.toString();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fromJson(Item item, String jsonString) {
        Item item2;
        if (!(item instanceof Network)) throw new IllegalArgumentException("Wrong type of item: " + item2.getClass().getSimpleName());
        item2 = (Network)item;
        try {
            JSONObject jSONObject;
            jSONObject = new JSONObject((String)jSONObject);
            if (jSONObject.has("ip")) {
                ((Network)item2).setIp(jSONObject.getString("ip"));
            }
            if (jSONObject.has("phoneType")) {
                ((Network)item2).setPhoneType(jSONObject.getString("phoneType"));
            }
            if (jSONObject.has("cellLocation")) {
                ((Network)item2).setCellLocation(jSONObject.getString("cellLocation"));
            }
            if (jSONObject.has("linkSpeed")) {
                ((Network)item2).setLinkSpeed(jSONObject.getInt("linkSpeed"));
            }
            if (jSONObject.has("networkType")) {
                ((Network)item2).setNetworkType(jSONObject.getString("networkType"));
            }
            if (jSONObject.has("ssid")) {
                ((Network)item2).setSsid(jSONObject.getString("ssid"));
            }
            if (jSONObject.has("securityType")) {
                ((Network)item2).setSecurityType(jSONObject.getString("securityType"));
            }
            if (jSONObject.has("signalStrength")) {
                ((Network)item2).setSignalStrength(jSONObject.getString("signalStrength"));
            }
            if (jSONObject.has("roamingActive")) {
                ((Network)item2).setRoamingActive(jSONObject.getBoolean("roamingActive"));
            }
            if (jSONObject.has("onlineTime")) {
                ((Network)item2).setOnlineTime(jSONObject.getInt("onlineTime"));
            }
            if (jSONObject.has("trafficReceived")) {
                ((Network)item2).setTrafficReceived(jSONObject.getLong("trafficReceived"));
            }
            if (jSONObject.has("trafficSent")) {
                ((Network)item2).setTrafficSent(jSONObject.getLong("trafficSent"));
            }
            if (!jSONObject.has("nearNetworks") || jSONObject.getJSONArray("nearNetworks").length() <= 0) return;
            ((Network)item2).setNearNetworks(NetworkHelper.a(jSONObject.getJSONArray("nearNetworks")));
            return;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.getMessage());
        }
    }

    private static JSONArray a(ArrayList<NetworkInformation> object) throws JSONException {
        JSONArray jSONArray = null;
        if (object != null && ((ArrayList)object).size() > 0) {
            jSONArray = new JSONArray();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                NetworkInformation networkInformation = (NetworkInformation)object.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("ssid", (Object)networkInformation.getSsid());
                jSONObject.put("securityType", (Object)networkInformation.getSecurityType());
                jSONObject.put("signalStrength", (Object)networkInformation.getSignalStrengthDescription());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    private static ArrayList<NetworkInformation> a(JSONArray jSONArray) throws JSONException {
        ArrayList<NetworkInformation> arrayList = new ArrayList<NetworkInformation>();
        for (int k = 0; k < jSONArray.length(); ++k) {
            NetworkInformation networkInformation = new NetworkInformation();
            networkInformation.setSsid(jSONArray.getJSONObject(k).getString("ssid"));
            networkInformation.setSignalStrengthDescription(jSONArray.getJSONObject(k).getString("signalStrength"));
            networkInformation.setSecurityType(jSONArray.getJSONObject(k).getString("securityType"));
            arrayList.add(networkInformation);
        }
        return arrayList;
    }
}

