/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.statemanager.itemhelpers;

import android.location.Location;
import com.intel.context.item.Item;
import com.intel.context.item.LocationCurrent;
import com.intel.context.statemanager.itemhelpers.BaseHelper;
import org.json.JSONException;
import org.json.JSONObject;

public final class LocationCurrentHelper
extends BaseHelper {
    private LocationCurrentHelper() {
    }

    public static boolean isStateItem() {
        return true;
    }

    public static boolean isHistoricalItem() {
        return true;
    }

    public static void fromJson(Item item, String jsonString) {
        Item item2;
        if (item instanceof LocationCurrent) {
            item2 = (LocationCurrent)item;
            try {
                JSONObject jSONObject;
                jSONObject = new JSONObject((String)jSONObject);
                Location location = new Location("stored");
                location.setLatitude(jSONObject.getDouble("latitude"));
                location.setLongitude(jSONObject.getDouble("longitude"));
                ((LocationCurrent)item2).setLocation(location);
                ((LocationCurrent)item2).setAccuracy(jSONObject.getDouble("accuracy"));
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Wrong type of item: " + item2.getClass().getSimpleName());
        }
    }

    public static String toJson(Item item) {
        JSONObject jSONObject;
        Object object;
        if (item instanceof LocationCurrent) {
            object = (LocationCurrent)item;
            jSONObject = new JSONObject();
            try {
                if (((LocationCurrent)object).getLocation() == null) {
                    throw new IllegalArgumentException("Not all mandatory attributes has been filled.");
                }
                jSONObject.put("longitude", ((LocationCurrent)object).getLocation().getLongitude());
                jSONObject.put("latitude", ((LocationCurrent)object).getLocation().getLatitude());
                jSONObject.put("accuracy", ((LocationCurrent)object).getAccuracy());
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Wrong type of item: " + object.getClass().getSimpleName());
        }
        object = jSONObject.toString();
        return object;
    }

    public static String getHistoricalValue(Item item) {
        return LocationCurrentHelper.toJson(item);
    }

    public static String getHistoricalExtension(Item item) {
        Item item2;
        return "{\"activity\": \"" + item2.getActivity() + "\"}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fromHistorical(Item item, String jsonString) {
        Item item2;
        if (!(item instanceof LocationCurrent)) throw new IllegalArgumentException("Wrong type of item: " + item2.getClass().getSimpleName());
        item2 = (LocationCurrent)item;
        try {
            JSONObject jSONObject;
            jSONObject = new JSONObject((String)jSONObject);
            JSONObject jSONObject2 = jSONObject.getJSONObject("value");
            Location location = new Location("historical");
            location.setLatitude(jSONObject2.getDouble("latitude"));
            location.setLongitude(jSONObject2.getDouble("longitude"));
            ((LocationCurrent)item2).setLocation(location);
            ((LocationCurrent)item2).setAccuracy(jSONObject2.getDouble("accuracy"));
            if (!jSONObject.has("extension")) return;
            jSONObject = jSONObject.getJSONObject("extension");
            item2.setActivity(jSONObject.getString("activity"));
            return;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.getMessage());
        }
    }
}

