/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.service;

import android.os.RemoteException;
import com.intel.context.service.CFException;
import com.intel.context.service.CFExceptionContainer;
import com.intel.context.service.IIdentifierQueryBinder;
import com.intel.context.service.IdentifierInfo;
import com.intel.context.service.IdentifierObserver;
import com.intel.context.service.IdentifierObserverWrapper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierQuery {
    IIdentifierQueryBinder binder;
    CFException genericException;

    /*
     * WARNING - void declaration
     */
    public IdentifierQuery(IIdentifierQueryBinder identifierQueryInterfaceBinder) {
        void var1_1;
        this.binder = var1_1;
        this.genericException = new CFException("There was a problem communicating with CAC", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INTERNAL);
    }

    public List<String> getContextList() throws CFException {
        try {
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            List<String> list = this.binder.getContextList(cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return list;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean identifierExists(String ident) throws CFException {
        if (ident == null) {
            throw new IllegalArgumentException();
        }
        try {
            void var1_1;
            boolean bl = this.binder.identifierExists((String)var1_1);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    public IdentifierInfo getIdentifierInfo(String ident) throws CFException {
        if (ident == null) {
            throw new IllegalArgumentException();
        }
        try {
            IdentifierInfo identifierInfo;
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            identifierInfo = this.binder.getIdentifierInfo((String)((Object)identifierInfo), cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return identifierInfo;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    public void addIdentifierObserver(IdentifierObserver identifierObserver) throws CFException {
        IdentifierObserverWrapper identifierObserverWrapper;
        if (identifierObserver == null) {
            throw new IllegalArgumentException();
        }
        identifierObserverWrapper = new IdentifierObserverWrapper((IdentifierObserver)((Object)identifierObserverWrapper));
        try {
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            this.binder.addIdentifierObserver(identifierObserverWrapper, cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    public void removeIdentifierObserver(IdentifierObserver identifierObserver) throws CFException {
        IdentifierObserverWrapper identifierObserverWrapper;
        if (identifierObserver == null) {
            throw new IllegalArgumentException();
        }
        identifierObserverWrapper = new IdentifierObserverWrapper((IdentifierObserver)((Object)identifierObserverWrapper));
        try {
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            this.binder.removeIdentifierObserver(identifierObserverWrapper, cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }
}

