/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.intel.context.service.AccessControl;
import com.intel.context.service.CFException;
import com.intel.context.service.Dummy;
import com.intel.context.service.Historical;
import com.intel.context.service.IAccessor;
import com.intel.context.service.IContextFramework;
import com.intel.context.service.IdentifierQuery;
import com.intel.context.service.Publisher;
import com.intel.context.service.Subscription;

public class Accessor {
    private ContextServiceConnection connection = null;
    private Context context = null;
    CFException genericException = new CFException("There was a problem communicating with CAC", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INTERNAL);
    private boolean connected = false;
    private int timeout = 5000;
    public static String CAC_SERVICE_DISCONECTED = "com.intel.context.service.SERVICE_DICONNECTED";
    public static final String PREFS_NAME = "CACPreferences";
    public static final int CAC_NON_ERROR = 0;
    public static final int CACSERVICE_CRASH = 1;
    private int serviceError = 0;
    private Context serviceContext = null;
    private boolean mIsBound;

    private void getServiceError() {
        try {
            this.serviceContext = this.context.createPackageContext("com.intel.context.service", 0);
            SharedPreferences sharedPreferences = this.serviceContext.getSharedPreferences(PREFS_NAME, 0);
            this.serviceError = sharedPreferences.getInt("status", 0);
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"CAC - Accessor", (String)("Data not shared" + nameNotFoundException.toString()));
            return;
        }
    }

    public void doBindService() {
        Log.i((String)"Accessor - CAC", (String)"CACService Bounded");
        Intent intent = new Intent("com.intel.context.service.CACService");
        this.context.bindService(intent, (ServiceConnection)this.connection, 1);
        this.mIsBound = true;
    }

    private void doUnbindService() {
        if (this.mIsBound) {
            this.context.unbindService((ServiceConnection)this.connection);
            this.mIsBound = false;
            Log.i((String)"Accessor - CAC", (String)"CACService UnBounded");
        }
    }

    public void sendBroadcast(String action) {
        Intent intent;
        Log.i((String)"Accessor - CAC", (String)"sendBroadcast");
        intent = new Intent((String)intent);
        intent.putExtra("ServiceError", this.serviceError);
        this.context.sendBroadcast(intent);
    }

    public Accessor(Context context) throws CFException {
        ConnectionThread connectionThread;
        if (context == null) {
            throw new CFException("Parameter 'context' was incorrect", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INVALID_PARAM);
        }
        this.context = connectionThread;
        connectionThread = new ConnectionThread();
        this.connection = new ContextServiceConnection();
        connectionThread.start();
    }

    public Subscription getSubscriptionInterface() throws CFException {
        ContextServiceConnection contextServiceConnection = this.connection;
        synchronized (contextServiceConnection) {
            if (!this.connected) {
                if (this.isUIThread()) {
                    throw new RuntimeException("Deadlock detected: do not retrieve interfaces from UI thread.");
                }
                try {
                    this.connection.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            try {
                if (this.connected) {
                    return new Subscription(this.connection.getRemoteAccessor().getSubscriptionInterface());
                }
                throw this.genericException;
            }
            catch (RemoteException remoteException) {
                throw this.genericException;
            }
        }
    }

    public IdentifierQuery getIdentifierQueryInterface() throws CFException {
        ContextServiceConnection contextServiceConnection = this.connection;
        synchronized (contextServiceConnection) {
            if (!this.connected) {
                if (this.isUIThread()) {
                    throw new RuntimeException("Deadlock detected: do not retrieve interfaces from UI thread.");
                }
                try {
                    this.connection.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            try {
                if (this.connection.isConnected()) {
                    return new IdentifierQuery(this.connection.getRemoteAccessor().getIdentifierQueryInterfaceBinder());
                }
                throw this.genericException;
            }
            catch (RemoteException remoteException) {
                throw this.genericException;
            }
        }
    }

    public AccessControl getAccessControlInterface() throws CFException {
        ContextServiceConnection contextServiceConnection = this.connection;
        synchronized (contextServiceConnection) {
            if (!this.connected) {
                if (this.isUIThread()) {
                    throw new RuntimeException("Deadlock detected: do not retrieve interfaces from UI thread.");
                }
                try {
                    this.connection.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            try {
                if (this.connected) {
                    return new AccessControl(this.connection.getRemoteAccessor().getAccessControlInterface());
                }
                throw this.genericException;
            }
            catch (RemoteException remoteException) {
                throw this.genericException;
            }
        }
    }

    public Publisher getPublisherInterface() throws CFException {
        ContextServiceConnection contextServiceConnection = this.connection;
        synchronized (contextServiceConnection) {
            if (!this.connected) {
                if (this.isUIThread()) {
                    throw new RuntimeException("Deadlock detected: do not retrieve interfaces from UI thread.");
                }
                try {
                    this.connection.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            try {
                if (this.connected) {
                    return new Publisher(this.connection.getRemoteAccessor().getPublisherInterface());
                }
                throw this.genericException;
            }
            catch (RemoteException remoteException) {
                throw this.genericException;
            }
        }
    }

    public Historical getHistoricalInterface() throws CFException {
        ContextServiceConnection contextServiceConnection = this.connection;
        synchronized (contextServiceConnection) {
            if (!this.connected) {
                if (this.isUIThread()) {
                    throw new RuntimeException("Deadlock detected: do not retrieve interfaces from UI thread.");
                }
                try {
                    this.connection.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
            try {
                if (this.connected) {
                    return new Historical(this.connection.getRemoteAccessor().getHistoricalInterface());
                }
                throw this.genericException;
            }
            catch (RemoteException remoteException) {
                throw this.genericException;
            }
        }
    }

    public void disconnect() {
        if (this.connection.isConnected()) {
            Log.i((String)"Accessor - CAC", (String)"CACService Disconnect");
            try {
                this.connection.cleanAccessor();
            }
            catch (RemoteException remoteException) {
                RemoteException remoteException2 = remoteException;
                remoteException.printStackTrace();
            }
            this.doUnbindService();
            this.connected = false;
        }
    }

    private boolean isUIThread() {
        String string = Looper.getMainLooper().getThread().toString();
        return string.equals(Thread.currentThread().toString());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(Accessor x0, boolean x1) {
        void var1_1;
        x0.connected = var1_1;
        return x0.connected;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$202(Accessor x0, int x1) {
        void var1_1;
        x0.serviceError = var1_1;
        return x0.serviceError;
    }

    class ConnectionThread
    extends Thread {
        private ConnectionThread() {
        }

        public void run() {
            Accessor.this.doBindService();
        }
    }

    class ContextServiceConnection
    implements ServiceConnection {
        private IContextFramework contextFramework = null;
        private IAccessor remoteAccessor = null;
        Dummy dummy = new Dummy();

        private ContextServiceConnection() {
        }

        public IAccessor getRemoteAccessor() {
            return this.remoteAccessor;
        }

        /*
         * WARNING - void declaration
         */
        public void onServiceConnected(ComponentName object, IBinder service) {
            block5: {
                void var2_2;
                Log.i((String)"Accessor - CAC", (String)"CACService Connected");
                this.contextFramework = IContextFramework.Stub.asInterface((IBinder)var2_2);
                try {
                    this.remoteAccessor = this.contextFramework.getAccessor();
                    if (this.remoteAccessor == null) break block5;
                    this.remoteAccessor.setDummy(this.dummy);
                    object = Accessor.this.connection;
                    synchronized (object) {
                        Accessor.access$102(Accessor.this, true);
                        Accessor.this.connection.notify();
                    }
                }
                catch (RemoteException remoteException) {
                    object = remoteException;
                    remoteException.printStackTrace();
                }
            }
            Accessor.access$202(Accessor.this, 0);
        }

        public void cleanAccessor() throws RemoteException {
            this.contextFramework.cleanAccessor(this.remoteAccessor);
            this.remoteAccessor = null;
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.i((String)"Accessor - CAC", (String)"CACService Disconnected");
            Accessor.access$102(Accessor.this, false);
            Accessor.this.doUnbindService();
            Accessor.this.getServiceError();
            Accessor.this.sendBroadcast(CAC_SERVICE_DISCONECTED);
        }

        public boolean isConnected() {
            return Accessor.this.connected;
        }
    }
}

