/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.service;

import android.os.RemoteException;
import com.intel.context.service.CFException;
import com.intel.context.service.CFExceptionContainer;
import com.intel.context.service.IAccessControlBinder;
import com.intel.context.service.PolicyMap;
import com.intel.context.service.a.a;
import com.intel.context.service.a.d;
import com.intel.context.service.a.e;
import com.intel.context.service.a.f;
import com.intel.context.service.a.g;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControl {
    private IAccessControlBinder binder;
    private CFException genericException;

    /*
     * WARNING - void declaration
     */
    public AccessControl(IAccessControlBinder accessControlBinder) {
        void var1_1;
        this.binder = var1_1;
        this.genericException = new CFException("There was a problem communicating with CAC", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INTERNAL);
    }

    /*
     * WARNING - void declaration
     */
    public boolean addPolicy(String policySetIdentifier, String xacmlPolicy) throws CFException {
        if (policySetIdentifier == null || xacmlPolicy == null) {
            throw new IllegalArgumentException();
        }
        try {
            void var2_3;
            void var1_1;
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            boolean bl = this.binder.addPolicy((String)var1_1, (String)var2_3, cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean removePolicy(String policySetIdentifier, String policyIdentifier) throws CFException {
        if (policySetIdentifier == null || policyIdentifier == null) {
            throw new IllegalArgumentException();
        }
        try {
            void var2_3;
            void var1_1;
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            boolean bl = this.binder.removePolicy((String)var1_1, (String)var2_3, cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public PolicyMap getPolicies(String policySetIdentifier, String resourceIdentifier) throws CFException {
        if (policySetIdentifier == null || resourceIdentifier == null) {
            throw new IllegalArgumentException();
        }
        try {
            void var2_2;
            PolicyMap policyMap;
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            policyMap = this.binder.getPolicies((String)((Object)policyMap), (String)var2_2, cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return policyMap;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean assertCredentials(CredentialType type, byte[] credential) throws CFException {
        if (type == null || credential == null) {
            throw new IllegalArgumentException();
        }
        try {
            void var2_3;
            void var1_1;
            CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
            boolean bl = this.binder.assertCredentials(((CredentialType)var1_1).code, (byte[])var2_3, cFExceptionContainer);
            if (!cFExceptionContainer.isEmpty()) {
                throw cFExceptionContainer.getE();
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            throw this.genericException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean assertCredentials(CredentialType type, String credential) throws CFException {
        if (type == null || credential == null) {
            throw new IllegalArgumentException();
        }
        try {
            void var1_1;
            byte[] byArray;
            byArray = byArray.getBytes("UTF-8");
            boolean bl = this.assertCredentials((CredentialType)var1_1, byArray);
            return bl;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.genericException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAllSame(List<String> list1, List<String> list2) {
        void var1_1;
        void var2_2;
        return list1.containsAll(list2) && var2_2.containsAll((Collection<?>)var1_1);
    }

    public boolean addAccessRequest(String permission) throws CFException {
        Object object;
        e e2;
        try {
            e2 = new e((String)((Object)e2));
        }
        catch (JSONException jSONException) {
            throw new CFException("Invalid Parameters", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INVALID_PARAM);
        }
        String string = e2.a();
        String string2 = e2.b();
        String string3 = e2.c();
        String string4 = e2.d();
        Map<String, a> map = e2.e();
        if (string == "" || string2 == "" || map == null) {
            throw new CFException("Invalid Parameters", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INVALID_PARAM);
        }
        new ArrayList();
        if (map.size() > 0) {
            object = null;
            for (Map.Entry entry : map.entrySet()) {
                if (object == null) {
                    object = (a)entry.getValue();
                }
                if (this.isAllSame(object.a(), ((a)entry.getValue()).a()) && object.b() == ((a)entry.getValue()).b()) continue;
                throw new CFException("Invalid Parameters", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INVALID_PARAM);
            }
        } else {
            throw new CFException("Invalid Parameters", CFException.Source.CFERROR_SRC_INTERFACE, CFException.ErrorCode.CFERROR_INVALID_PARAM);
        }
        boolean bl = object.b();
        object = (ArrayList)object.a();
        object = new f(string, string4, map, string2, string3, (ArrayList<String>)object, bl);
        String string5 = ((f)object).toString();
        return this.addPolicy("User", string5);
    }

    public boolean deleteAccessRequest(String id) throws CFException {
        boolean bl;
        CFException cFException;
        try {
            bl = this.removePolicy("User", (String)((Object)cFException));
        }
        catch (CFException cFException2) {
            cFException = cFException2;
            throw cFException2;
        }
        return bl;
    }

    public List<String> getAccessRequest() throws CFException {
        Object object;
        Serializable serializable = new ArrayList<String>();
        try {
            object = this.getPolicies("User", "All");
        }
        catch (CFException cFException) {
            CFException cFException2 = cFException;
            throw cFException;
        }
        object = ((PolicyMap)object).get("User");
        for (int k = 0; k < object.size(); ++k) {
            String string;
            try {
                string = this.convertToJson((String)object.get(k));
            }
            catch (CFException cFException) {
                serializable = cFException;
                throw cFException;
            }
            serializable.add((String)string);
        }
        return serializable;
    }

    private String convertToJson(String xacml) throws CFException {
        d d2;
        String string;
        g g2 = new g();
        try {
            g2.a(string);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new CFException(xmlPullParserException.getMessage(), CFException.Source.CFERROR_SRC_FRAMEWORK, CFException.ErrorCode.CFERROR_INTERNAL);
        }
        catch (IOException iOException) {
            throw new CFException(iOException.getMessage(), CFException.Source.CFERROR_SRC_FRAMEWORK, CFException.ErrorCode.CFERROR_INTERNAL);
        }
        string = g2.b();
        Object object2 = g2.d();
        String string2 = object2.get("requesterApplication");
        String string3 = object2.get("CERTIFICATE");
        object2 = object2.get("USER");
        ArrayList<String> arrayList = g2.c();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String object3 : arrayList) {
            hashMap.put(object3, g2.a());
        }
        arrayList = new ArrayList<String>();
        if (g2.e()) {
            arrayList.add("read");
        }
        if (g2.f()) {
            arrayList.add("create");
        }
        try {
            d2 = new d(string, "", string2, string3, (String)object2, hashMap, arrayList);
        }
        catch (JSONException jSONException) {
            throw new CFException(jSONException.getMessage(), CFException.Source.CFERROR_SRC_FRAMEWORK, CFException.ErrorCode.CFERROR_INTERNAL);
        }
        return d2.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CredentialType {
        XACML_REQUEST_ATTRIBUTES_APP_ASSERTED(0);

        private int code;

        /*
         * WARNING - void declaration
         */
        private CredentialType(int code) {
            void var3_3;
            this.code = var3_3;
        }

        public final int getCode() {
            return this.code;
        }
    }
}

