/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.provider.cxx.cdf;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.intel.context.provider.IProviderPublisher;
import com.intel.context.provider.IStateProvider;
import com.intel.context.provider.cxx.cdf.NativeLayerAccess;
import com.intel.context.service.CFExceptionContainer;
import com.intel.context.service.DataSetIdent;
import com.intel.context.service.ISourcePublisher;
import com.intel.context.service.SubscriptionTuplet;
import com.intel.exception.ContextProviderException;
import java.io.File;

public class ProviderNativeContextSource
implements IStateProvider {
    private static final String TAG = ProviderNativeContextSource.class.getName();
    private SubscriptionTuplet mTuple = new SubscriptionTuplet();
    private String mLibraryName;
    private DataSetIdent mDataSetIdent;
    private ISourcePublisher mSourcePublisher;
    private String mPublisherClassName;

    /*
     * WARNING - void declaration
     */
    public ProviderNativeContextSource(String libraryName, String identifier, String options, String publisherClassName) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.mTuple.identifier = var2_2;
        this.mTuple.options = var3_3;
        this.mLibraryName = var1_1;
        this.mPublisherClassName = publisherClassName;
    }

    /*
     * WARNING - void declaration
     */
    public void start(Context context, IProviderPublisher publisher, Bundle object) throws ContextProviderException {
        void var1_1;
        try {
            object = Class.forName(this.mPublisherClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ContextProviderException(classNotFoundException.getMessage());
        }
        try {
            void var2_4;
            this.mSourcePublisher = (ISourcePublisher)((Class)object).getDeclaredConstructor(IProviderPublisher.class).newInstance(var2_4);
        }
        catch (Exception exception) {
            throw new ContextProviderException(exception.getMessage());
        }
        this.activateContext((Context)var1_1, this.mSourcePublisher);
    }

    public void stop() {
        try {
            this.deactivateContext();
            return;
        }
        catch (ContextProviderException contextProviderException) {
            Log.e((String)TAG, (String)("Error Stopping native provider: " + contextProviderException.getMessage()));
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("General Exception Stopping native provider: " + exception.getMessage()));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void activateContext(Context context, ISourcePublisher sourcePublisher) throws ContextProviderException {
        void var2_2;
        Object object;
        CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
        object = object.getFilesDir();
        object = ((File)object).getAbsolutePath();
        object = (String)object + File.separator + this.mLibraryName;
        Log.d((String)TAG, (String)("Native Library directory: " + (String)object));
        this.mDataSetIdent = NativeLayerAccess.activateContext((String)object, this.mTuple, (ISourcePublisher)var2_2, cFExceptionContainer);
        if (this.mDataSetIdent == null) {
            throw new ContextProviderException(cFExceptionContainer.getE().getMessage());
        }
    }

    private void deactivateContext() throws ContextProviderException {
        CFExceptionContainer cFExceptionContainer = new CFExceptionContainer();
        if (!NativeLayerAccess.deactivateContext(this.mDataSetIdent, cFExceptionContainer)) {
            throw new ContextProviderException(cFExceptionContainer.getE().getMessage());
        }
    }
}

