/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.provider.cxx.cdf;

import android.os.Bundle;
import android.util.Log;
import com.intel.context.Sensing;
import com.intel.context.core.LocalService;
import com.intel.context.error.ContextError;
import com.intel.context.error.ErrorCode;
import com.intel.context.item.ContextType;
import com.intel.context.sensing.ContextTypeListener;
import com.intel.context.service.SubscriptionTuplet;
import com.intel.context.statemanager.b;
import com.intel.exception.ContextProviderException;

public class NativeSubscriber {
    private static final String TAG = NativeSubscriber.class.getName();
    private static Sensing mSensing = null;

    private NativeSubscriber() {
    }

    /*
     * WARNING - void declaration
     */
    public static void subscribe(SubscriptionTuplet tuplet, ContextTypeListener callback) {
        void var1_1;
        if (tuplet.getIdentifier() == null || tuplet.getIdentifier().length() == 0) {
            Log.e((String)TAG, (String)("Error invalid Provider: " + tuplet.getIdentifier()));
            callback.onError(new ContextError("Error invalid Provider: " + tuplet.getIdentifier(), ErrorCode.GENERIC_ERROR));
            return;
        }
        ContextType contextType = ContextType.getValueOf(tuplet.getIdentifier());
        if (mSensing == null) {
            mSensing = new Sensing(LocalService.getAppContext(), null);
        }
        try {
            Bundle bundle = null;
            if (tuplet.getOptions().length() != 0) {
                bundle = new Bundle();
                bundle.putString("options", tuplet.getOptions());
            }
            mSensing.enableSensing(contextType, bundle);
        }
        catch (ContextProviderException contextProviderException) {
            SubscriptionTuplet subscriptionTuplet;
            Log.d((String)TAG, (String)("Provider already enabled: " + subscriptionTuplet.getIdentifier()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)("Error enabling provider: " + illegalArgumentException.getMessage()));
            callback.onError(new ContextError("Error enabling Provider: " + illegalArgumentException.getMessage(), ErrorCode.GENERIC_ERROR));
            return;
        }
        b.a().a(contextType, callback);
        var1_1.onError(new ContextError("Subscription Successful", ErrorCode.NO_ERROR));
    }

    public static void unSubscribe(ContextTypeListener callback) {
        ContextTypeListener contextTypeListener;
        Log.d((String)TAG, (String)"Removing listener");
        b.a().a(callback);
        contextTypeListener.onError(new ContextError("UnSubscription Successful", ErrorCode.NO_ERROR));
    }
}

