/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context.provider.cxx.cdf;

import android.util.Log;
import com.intel.context.error.ContextError;
import com.intel.context.error.ErrorCode;
import com.intel.context.provider.cxx.cdf.NativeLayerAccess;
import com.intel.context.sensing.ContextTypeListener;
import com.intel.context.service.CFSubscriptionState;
import com.intel.context.service.DataSetIdent;
import com.intel.context.service.Item;
import com.intel.context.statemanager.itemhelpers.ItemHelper;

public class NativeListener
implements ContextTypeListener {
    private static final String TAG = NativeListener.class.getName();
    private int mNativeObserver;
    private DataSetIdent mdataSet;

    /*
     * WARNING - void declaration
     */
    public NativeListener(int nativeObserver, DataSetIdent dataSet) {
        void var2_2;
        void var1_1;
        this.mNativeObserver = var1_1;
        this.mdataSet = var2_2;
    }

    public void onReceive(com.intel.context.item.Item item) {
        String string = ItemHelper.getStateValue(item);
        Log.d((String)TAG, (String)("NativeListener item: " + string));
        Item item2 = new Item();
        item2.setValue(string);
        NativeLayerAccess.itemReceived(this.mNativeObserver, item2);
    }

    /*
     * WARNING - void declaration
     */
    public void onError(ContextError error) {
        void var1_1;
        CFSubscriptionState cFSubscriptionState = new CFSubscriptionState();
        if (error.getMessage().equals("Subscription Successfull")) {
            cFSubscriptionState.action_code = CFSubscriptionState.CFActionCode.ACODE_ADD_ITEM_OBSERVER;
            if (error.getCode() == ErrorCode.NO_ERROR) {
                cFSubscriptionState.status_code = CFSubscriptionState.CFActionStatus.ASTATUS_SUBSCRIPTION_OK;
            } else {
                Log.e((String)TAG, (String)("Error adding listener: " + error.getMessage()));
                cFSubscriptionState.status_code = CFSubscriptionState.CFActionStatus.ASTATUS_SUBSCRIPTION_ERROR;
            }
        } else if (error.getMessage().equals("UnSubscription Successfull")) {
            cFSubscriptionState.action_code = CFSubscriptionState.CFActionCode.ACODE_REMOVE_ITEM_OBSERVER;
            if (error.getCode() == ErrorCode.NO_ERROR) {
                cFSubscriptionState.status_code = CFSubscriptionState.CFActionStatus.ASTATUS_SUBSCRIPTION_REMOVED_OK;
            } else {
                Log.e((String)TAG, (String)("Error removing listener: " + error.getMessage()));
                cFSubscriptionState.status_code = CFSubscriptionState.CFActionStatus.ASTATUS_SUBSCRIPTION_REMOVED_ERROR;
            }
        } else {
            Log.e((String)TAG, (String)("General error in NativeListener: " + error.getMessage()));
            cFSubscriptionState.status_code = CFSubscriptionState.CFActionStatus.ASTATUS_UNDEFINED_ACTION_STATUS;
            cFSubscriptionState.action_code = CFSubscriptionState.CFActionCode.ACODE_UNDEFINED_ACTION_CODE;
        }
        cFSubscriptionState.message = var1_1.getMessage();
        NativeLayerAccess.subscriptionStatus(this.mNativeObserver, this.mdataSet, cFSubscriptionState);
    }
}

