/*
 * Decompiled with CFR 0.152.
 */
package com.intel.context;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.intel.common.a;
import com.intel.context.core.ILocalService;
import com.intel.context.core.b;
import com.intel.context.core.e;
import com.intel.context.core.f;
import com.intel.context.error.ContextError;
import com.intel.context.error.ErrorCode;
import com.intel.context.item.ContextType;
import com.intel.context.item.Custom;
import com.intel.context.item.Item;
import com.intel.context.sensing.ContextTypeListener;
import com.intel.context.sensing.GetItemCallback;
import com.intel.context.sensing.InitCallback;
import com.intel.context.sensing.SensingEvent;
import com.intel.context.sensing.SensingStatusListener;
import com.intel.context.sensing.SetItemCallback;
import com.intel.context.statemanager.d;
import com.intel.exception.ContextProviderException;

public class Sensing {
    private static final String a = Sensing.class.getName();
    private static ILocalService b;
    private b c = new b();
    private Context d;
    private InternalStartServiceCallback e;
    private SensingStatusListener f;
    private d g;

    /*
     * WARNING - void declaration
     */
    public Sensing(Context context) {
        void var1_1;
        if (context == null) {
            throw new IllegalArgumentException("appContext cannot be null");
        }
        this.d = var1_1;
        this.e = new InternalStartServiceCallback(this, null, null);
        this.g = com.intel.common.a.getStateManager();
        com.intel.common.a.getCloudSync(this.d);
    }

    /*
     * WARNING - void declaration
     */
    public Sensing(Context context, SensingStatusListener statusListener) {
        void var2_2;
        void var1_1;
        if (context == null) {
            throw new IllegalArgumentException("appContext cannot be null");
        }
        this.d = var1_1;
        this.f = var2_2;
        this.e = new InternalStartServiceCallback(this, this.f, null);
        this.g = com.intel.common.a.getStateManager();
        com.intel.common.a.getCloudSync(this.d);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void start(InitCallback callback) {
        void var1_1;
        if (b == null) {
            Log.i((String)a, (String)"Starting Context Daemon");
            try {
                this.e.setOnInitCallback(callback);
                boolean bl = this.c.a(this.d, this.e);
                if (!bl) {
                    callback.onError(new ContextError("Error starting Context Daemon. Make sure you included the service reference in the app manifest", ErrorCode.SERVICE_BOUND_ERROR));
                }
                return;
            }
            catch (SecurityException securityException) {
                callback.onError(new ContextError("Error starting Context Daemon.", ErrorCode.SERVICE_SECURITY_ERROR));
                return;
            }
            catch (RuntimeException runtimeException) {
                callback.onError(new ContextError("Error starting Context Daemon.", ErrorCode.GENERIC_ERROR));
                return;
            }
        }
        Log.i((String)a, (String)"Context Daemon already started. Skipping initialization.");
        var1_1.onError(new ContextError("Context Daemon already started.", ErrorCode.SERVICE_START_ERROR));
    }

    public synchronized void stop() {
        if (this.d == null || b == null) {
            throw new IllegalArgumentException("Context Daemon was not started before.");
        }
        if (b != null) {
            try {
                this.disableSensing();
                this.c.a(this.d);
                Log.i((String)a, (String)"Context Daemon finished");
                if (this.f != null) {
                    this.f.onEvent(new SensingEvent(SensingEvent.Code.SERVICE_STOPPED, "Context Daemon stopped"));
                }
                b = null;
                this.f = null;
                return;
            }
            catch (SecurityException securityException) {
                Log.e((String)a, (String)("Exception trying to stop Context Daemon. " + securityException.getMessage()));
                if (this.f != null) {
                    this.f.onFail(new ContextError("Error stopping Context Daemon", ErrorCode.SERVICE_SECURITY_ERROR));
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                this.f.onFail(new ContextError("Error starting Context Daemon.", ErrorCode.GENERIC_ERROR));
                return;
            }
            catch (ContextProviderException contextProviderException) {
                Log.e((String)a, (String)("Error trying to disable sensing. " + contextProviderException.getMessage()));
                return;
            }
        }
        Log.w((String)a, (String)"There is no Context Daemon instance or the instance was not started.");
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void enableSensing(ContextType type, Bundle settings) throws ContextProviderException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (b != null) {
            Sensing sensing;
            void var2_2;
            void var3_3 = var2_2;
            var2_2 = sensing;
            sensing = this;
            try {
                b.enableProvider((ContextType)var2_2, (Bundle)var3_3);
                Log.i((String)a, (String)("Context sensing enabled for: " + var2_2.toString()));
            }
            catch (f f2) {
                Log.e((String)a, (String)("Error: " + f2.getMessage()));
                sensing.e.onError(new ContextError("Error enabling provider " + var2_2.getShortName(), ErrorCode.PROVIDER_ERROR));
                throw new ContextProviderException(f2.getMessage());
            }
            catch (ContextProviderException contextProviderException) {
                Log.e((String)a, (String)("Error: " + contextProviderException.getMessage()));
                throw new ContextProviderException("Error enabling provider " + var2_2.getShortName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)a, (String)("Error enabling sensing of specified context type. Make sure the context provider is available in the system. Root cause: " + illegalArgumentException.getMessage()));
                throw new IllegalArgumentException("Error enabling provider " + var2_2.getShortName());
            }
        } else {
            Log.e((String)a, (String)"Error enabling item. Please enable Context Sensing Daemon.");
            throw new ContextProviderException("Context Daemon not started, Please enable Context Sensing Daemon.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void enableSensing(String customTypeUri, Bundle settings) throws ContextProviderException {
        void var2_2;
        ContextType contextType;
        if (customTypeUri == null) {
            throw new IllegalArgumentException("customTypeUri cannot be null");
        }
        contextType = new ContextType(customTypeUri, (String)((Object)contextType), Custom.class);
        this.enableSensing(contextType, (Bundle)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void disableSensing(ContextType type) throws ContextProviderException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (b != null) {
            try {
                void var1_1;
                b.disableProvider(type);
                Log.i((String)a, (String)("Sensing disabled for: " + var1_1.toString()));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)a, (String)"Error disabling sensing. Make sure the specified context type exists.");
                throw new ContextProviderException("Specified context type does not exists");
            }
        }
        Log.e((String)a, (String)"Error disabling sensing. Please enable Context Sensing Daemon.");
        throw new ContextProviderException("Context Daemon not started, Please enable Context Sensing Daemon.");
    }

    public final synchronized void disableSensing(String customTypeUri) throws ContextProviderException {
        ContextType contextType;
        contextType = new ContextType(customTypeUri, (String)((Object)contextType), Custom.class);
        this.disableSensing(contextType);
    }

    public final synchronized void disableSensing() throws ContextProviderException {
        if (b != null) {
            b.disableProviders();
            return;
        }
        Log.e((String)a, (String)"Error disabling sensing. Please call enableSensing before disableSensing");
        throw new ContextProviderException("Context Daemon not initialized");
    }

    /*
     * WARNING - void declaration
     */
    public final void addContextTypeListener(ContextType type, ContextTypeListener listener) throws ContextProviderException {
        void var2_2;
        void var1_1;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Log.i((String)a, (String)("Adding Listener to: " + type));
        this.g.a((ContextType)var1_1, (ContextTypeListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addContextTypeListener(String customTypeUri, ContextTypeListener listener) throws ContextProviderException {
        void var2_2;
        ContextType contextType;
        contextType = new ContextType(customTypeUri, (String)((Object)contextType), Custom.class);
        this.addContextTypeListener(contextType, (ContextTypeListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeContextTypeListener(ContextTypeListener listener) throws ContextProviderException {
        void var1_1;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        Log.i((String)a, (String)"Removing Listener");
        this.g.a((ContextTypeListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setItem(Item item, SetItemCallback callback) throws ContextProviderException {
        void var2_2;
        void var1_1;
        Log.i((String)a, (String)"Set Item");
        this.g.a((Item)var1_1, (SetItemCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void getItem(ContextType type, GetItemCallback callback) throws ContextProviderException {
        void var2_2;
        void var1_1;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.i((String)a, (String)"Get Item");
        this.g.a((ContextType)var1_1, (GetItemCallback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void getItem(String customTypeUri, GetItemCallback callback) throws ContextProviderException {
        void var2_2;
        ContextType contextType;
        if (customTypeUri == null) {
            throw new IllegalArgumentException("customTypeUri cannot be null");
        }
        contextType = new ContextType(customTypeUri, (String)((Object)contextType), Custom.class);
        this.getItem(contextType, (GetItemCallback)var2_2);
    }

    class InternalStartServiceCallback
    implements e {
        private SensingStatusListener a;
        private InitCallback b;

        /*
         * WARNING - void declaration
         */
        public InternalStartServiceCallback(Sensing sensing, SensingStatusListener statusListener, InitCallback initCallback) {
            void var3_3;
            void var2_2;
            this.a = var2_2;
            this.b = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public void setOnInitCallback(InitCallback callback) {
            if (callback != null) {
                void var1_1;
                this.b = var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setOnStatusListener(SensingStatusListener listener) {
            if (listener != null) {
                void var1_1;
                this.a = var1_1;
            }
        }

        public void onSuccess(ILocalService service) {
            b = service;
            if (this.b != null) {
                this.b.onSuccess();
            }
            if (this.a != null) {
                this.a.onEvent(new SensingEvent(SensingEvent.Code.SERVICE_STARTED, "Context Daemon started"));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onError(ContextError error) {
            Log.e((String)a, (String)("Context Sensing Error: " + error.getMessage()));
            if (this.b != null) {
                void var1_1;
                this.b.onError((ContextError)var1_1);
            }
        }
    }
}

